/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDBInstanceReadReplicaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDBInstanceReadReplicaRequest> {
    private final String dbInstanceIdentifier;
    private final String sourceDBInstanceIdentifier;
    private final String dbInstanceClass;
    private final String availabilityZone;
    private final Integer port;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer iops;
    private final String optionGroupName;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;
    private final String dbSubnetGroupName;
    private final String storageType;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean enableIAMDatabaseAuthentication;
    private final String sourceRegion;

    private CreateDBInstanceReadReplicaRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.sourceDBInstanceIdentifier = builder.sourceDBInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.availabilityZone = builder.availabilityZone;
        this.port = builder.port;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.storageType = builder.storageType;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.sourceRegion = builder.sourceRegion;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String sourceDBInstanceIdentifier() {
        return this.sourceDBInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Integer port() {
        return this.port;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Integer iops() {
        return this.iops;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String storageType() {
        return this.storageType;
    }

    public Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.sourceDBInstanceIdentifier() == null ? 0 : this.sourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceClass() == null ? 0 : this.dbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.autoMinorVersionUpgrade() == null ? 0 : this.autoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.publiclyAccessible() == null ? 0 : this.publiclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.storageType() == null ? 0 : this.storageType().hashCode());
        hashCode = 31 * hashCode + (this.copyTagsToSnapshot() == null ? 0 : this.copyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.monitoringInterval() == null ? 0 : this.monitoringInterval().hashCode());
        hashCode = 31 * hashCode + (this.monitoringRoleArn() == null ? 0 : this.monitoringRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.preSignedUrl() == null ? 0 : this.preSignedUrl().hashCode());
        hashCode = 31 * hashCode + (this.enableIAMDatabaseAuthentication() == null ? 0 : this.enableIAMDatabaseAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.sourceRegion() == null ? 0 : this.sourceRegion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBInstanceReadReplicaRequest)) {
            return false;
        }
        CreateDBInstanceReadReplicaRequest other = (CreateDBInstanceReadReplicaRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.sourceDBInstanceIdentifier() == null ^ this.sourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.sourceDBInstanceIdentifier() != null && !other.sourceDBInstanceIdentifier().equals(this.sourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.dbInstanceClass() == null ^ this.dbInstanceClass() == null) {
            return false;
        }
        if (other.dbInstanceClass() != null && !other.dbInstanceClass().equals(this.dbInstanceClass())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() == null ^ this.autoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.autoMinorVersionUpgrade() != null && !other.autoMinorVersionUpgrade().equals(this.autoMinorVersionUpgrade())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.publiclyAccessible() == null ^ this.publiclyAccessible() == null) {
            return false;
        }
        if (other.publiclyAccessible() != null && !other.publiclyAccessible().equals(this.publiclyAccessible())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.storageType() == null ^ this.storageType() == null) {
            return false;
        }
        if (other.storageType() != null && !other.storageType().equals(this.storageType())) {
            return false;
        }
        if (other.copyTagsToSnapshot() == null ^ this.copyTagsToSnapshot() == null) {
            return false;
        }
        if (other.copyTagsToSnapshot() != null && !other.copyTagsToSnapshot().equals(this.copyTagsToSnapshot())) {
            return false;
        }
        if (other.monitoringInterval() == null ^ this.monitoringInterval() == null) {
            return false;
        }
        if (other.monitoringInterval() != null && !other.monitoringInterval().equals(this.monitoringInterval())) {
            return false;
        }
        if (other.monitoringRoleArn() == null ^ this.monitoringRoleArn() == null) {
            return false;
        }
        if (other.monitoringRoleArn() != null && !other.monitoringRoleArn().equals(this.monitoringRoleArn())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.preSignedUrl() == null ^ this.preSignedUrl() == null) {
            return false;
        }
        if (other.preSignedUrl() != null && !other.preSignedUrl().equals(this.preSignedUrl())) {
            return false;
        }
        if (other.enableIAMDatabaseAuthentication() == null ^ this.enableIAMDatabaseAuthentication() == null) {
            return false;
        }
        if (other.enableIAMDatabaseAuthentication() != null && !other.enableIAMDatabaseAuthentication().equals(this.enableIAMDatabaseAuthentication())) {
            return false;
        }
        if (other.sourceRegion() == null ^ this.sourceRegion() == null) {
            return false;
        }
        return other.sourceRegion() == null || other.sourceRegion().equals(this.sourceRegion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.sourceDBInstanceIdentifier() != null) {
            sb.append("SourceDBInstanceIdentifier: ").append(this.sourceDBInstanceIdentifier()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.autoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.autoMinorVersionUpgrade()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.publiclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.publiclyAccessible()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.storageType() != null) {
            sb.append("StorageType: ").append(this.storageType()).append(",");
        }
        if (this.copyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.copyTagsToSnapshot()).append(",");
        }
        if (this.monitoringInterval() != null) {
            sb.append("MonitoringInterval: ").append(this.monitoringInterval()).append(",");
        }
        if (this.monitoringRoleArn() != null) {
            sb.append("MonitoringRoleArn: ").append(this.monitoringRoleArn()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.preSignedUrl() != null) {
            sb.append("PreSignedUrl: ").append(this.preSignedUrl()).append(",");
        }
        if (this.enableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.enableIAMDatabaseAuthentication()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String sourceDBInstanceIdentifier;
        private String dbInstanceClass;
        private String availabilityZone;
        private Integer port;
        private Boolean autoMinorVersionUpgrade;
        private Integer iops;
        private String optionGroupName;
        private Boolean publiclyAccessible;
        private List<Tag> tags;
        private String dbSubnetGroupName;
        private String storageType;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean enableIAMDatabaseAuthentication;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDBInstanceReadReplicaRequest model) {
            this.setDBInstanceIdentifier(model.dbInstanceIdentifier);
            this.setSourceDBInstanceIdentifier(model.sourceDBInstanceIdentifier);
            this.setDBInstanceClass(model.dbInstanceClass);
            this.setAvailabilityZone(model.availabilityZone);
            this.setPort(model.port);
            this.setAutoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.setIops(model.iops);
            this.setOptionGroupName(model.optionGroupName);
            this.setPubliclyAccessible(model.publiclyAccessible);
            this.setTags(model.tags);
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setStorageType(model.storageType);
            this.setCopyTagsToSnapshot(model.copyTagsToSnapshot);
            this.setMonitoringInterval(model.monitoringInterval);
            this.setMonitoringRoleArn(model.monitoringRoleArn);
            this.setKmsKeyId(model.kmsKeyId);
            this.setPreSignedUrl(model.preSignedUrl);
            this.setEnableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.setSourceRegion(model.sourceRegion);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getSourceDBInstanceIdentifier() {
            return this.sourceDBInstanceIdentifier;
        }

        @Override
        public final Builder sourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
            return this;
        }

        public final void setSourceDBInstanceIdentifier(String sourceDBInstanceIdentifier) {
            this.sourceDBInstanceIdentifier = sourceDBInstanceIdentifier;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public CreateDBInstanceReadReplicaRequest build() {
            return new CreateDBInstanceReadReplicaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDBInstanceReadReplicaRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder sourceDBInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder availabilityZone(String var1);

        public Builder port(Integer var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder storageType(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder sourceRegion(String var1);
    }
}

