/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDBClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDBClusterRequest> {
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final String dbSubnetGroupName;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String masterUsername;
    private final String masterUserPassword;
    private final String optionGroupName;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<Tag> tags;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean enableIAMDatabaseAuthentication;

    private CreateDBClusterRequest(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.tags = builder.tags;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer port() {
        return this.port;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionPeriod() == null ? 0 : this.backupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.characterSetName() == null ? 0 : this.characterSetName().hashCode());
        hashCode = 31 * hashCode + (this.databaseName() == null ? 0 : this.databaseName().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterParameterGroupName() == null ? 0 : this.dbClusterParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupIds() == null ? 0 : this.vpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.masterUserPassword() == null ? 0 : this.masterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.replicationSourceIdentifier() == null ? 0 : this.replicationSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.storageEncrypted() == null ? 0 : this.storageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.preSignedUrl() == null ? 0 : this.preSignedUrl().hashCode());
        hashCode = 31 * hashCode + (this.enableIAMDatabaseAuthentication() == null ? 0 : this.enableIAMDatabaseAuthentication().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBClusterRequest)) {
            return false;
        }
        CreateDBClusterRequest other = (CreateDBClusterRequest)((Object)obj);
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.backupRetentionPeriod() == null ^ this.backupRetentionPeriod() == null) {
            return false;
        }
        if (other.backupRetentionPeriod() != null && !other.backupRetentionPeriod().equals(this.backupRetentionPeriod())) {
            return false;
        }
        if (other.characterSetName() == null ^ this.characterSetName() == null) {
            return false;
        }
        if (other.characterSetName() != null && !other.characterSetName().equals(this.characterSetName())) {
            return false;
        }
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        if (other.databaseName() != null && !other.databaseName().equals(this.databaseName())) {
            return false;
        }
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.dbClusterParameterGroupName() == null ^ this.dbClusterParameterGroupName() == null) {
            return false;
        }
        if (other.dbClusterParameterGroupName() != null && !other.dbClusterParameterGroupName().equals(this.dbClusterParameterGroupName())) {
            return false;
        }
        if (other.vpcSecurityGroupIds() == null ^ this.vpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.vpcSecurityGroupIds() != null && !other.vpcSecurityGroupIds().equals(this.vpcSecurityGroupIds())) {
            return false;
        }
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.masterUserPassword() == null ^ this.masterUserPassword() == null) {
            return false;
        }
        if (other.masterUserPassword() != null && !other.masterUserPassword().equals(this.masterUserPassword())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.replicationSourceIdentifier() == null ^ this.replicationSourceIdentifier() == null) {
            return false;
        }
        if (other.replicationSourceIdentifier() != null && !other.replicationSourceIdentifier().equals(this.replicationSourceIdentifier())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.storageEncrypted() == null ^ this.storageEncrypted() == null) {
            return false;
        }
        if (other.storageEncrypted() != null && !other.storageEncrypted().equals(this.storageEncrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.preSignedUrl() == null ^ this.preSignedUrl() == null) {
            return false;
        }
        if (other.preSignedUrl() != null && !other.preSignedUrl().equals(this.preSignedUrl())) {
            return false;
        }
        if (other.enableIAMDatabaseAuthentication() == null ^ this.enableIAMDatabaseAuthentication() == null) {
            return false;
        }
        return other.enableIAMDatabaseAuthentication() == null || other.enableIAMDatabaseAuthentication().equals(this.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.backupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.backupRetentionPeriod()).append(",");
        }
        if (this.characterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.characterSetName()).append(",");
        }
        if (this.databaseName() != null) {
            sb.append("DatabaseName: ").append(this.databaseName()).append(",");
        }
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.dbClusterParameterGroupName() != null) {
            sb.append("DBClusterParameterGroupName: ").append(this.dbClusterParameterGroupName()).append(",");
        }
        if (this.vpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.vpcSecurityGroupIds()).append(",");
        }
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.masterUserPassword() != null) {
            sb.append("MasterUserPassword: ").append(this.masterUserPassword()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.replicationSourceIdentifier() != null) {
            sb.append("ReplicationSourceIdentifier: ").append(this.replicationSourceIdentifier()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.storageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.storageEncrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.preSignedUrl() != null) {
            sb.append("PreSignedUrl: ").append(this.preSignedUrl()).append(",");
        }
        if (this.enableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.enableIAMDatabaseAuthentication()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones;
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroupName;
        private List<String> vpcSecurityGroupIds;
        private String dbSubnetGroupName;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String masterUsername;
        private String masterUserPassword;
        private String optionGroupName;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<Tag> tags;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDBClusterRequest model) {
            this.setAvailabilityZones(model.availabilityZones);
            this.setBackupRetentionPeriod(model.backupRetentionPeriod);
            this.setCharacterSetName(model.characterSetName);
            this.setDatabaseName(model.databaseName);
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setDBClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.setVpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setPort(model.port);
            this.setMasterUsername(model.masterUsername);
            this.setMasterUserPassword(model.masterUserPassword);
            this.setOptionGroupName(model.optionGroupName);
            this.setPreferredBackupWindow(model.preferredBackupWindow);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setReplicationSourceIdentifier(model.replicationSourceIdentifier);
            this.setTags(model.tags);
            this.setStorageEncrypted(model.storageEncrypted);
            this.setKmsKeyId(model.kmsKeyId);
            this.setPreSignedUrl(model.preSignedUrl);
            this.setEnableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDBClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDBClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @SafeVarargs
        public final void setVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public CreateDBClusterRequest build() {
            return new CreateDBClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDBClusterRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder optionGroupName(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);
    }
}

