/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyDBSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopyDBSnapshotRequest> {
    private final String sourceDBSnapshotIdentifier;
    private final String targetDBSnapshotIdentifier;
    private final String kmsKeyId;
    private final List<Tag> tags;
    private final Boolean copyTags;
    private final String preSignedUrl;
    private final String optionGroupName;
    private final String sourceRegion;

    private CopyDBSnapshotRequest(BuilderImpl builder) {
        this.sourceDBSnapshotIdentifier = builder.sourceDBSnapshotIdentifier;
        this.targetDBSnapshotIdentifier = builder.targetDBSnapshotIdentifier;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.copyTags = builder.copyTags;
        this.preSignedUrl = builder.preSignedUrl;
        this.optionGroupName = builder.optionGroupName;
        this.sourceRegion = builder.sourceRegion;
    }

    public String sourceDBSnapshotIdentifier() {
        return this.sourceDBSnapshotIdentifier;
    }

    public String targetDBSnapshotIdentifier() {
        return this.targetDBSnapshotIdentifier;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean copyTags() {
        return this.copyTags;
    }

    public String preSignedUrl() {
        return this.preSignedUrl;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceDBSnapshotIdentifier() == null ? 0 : this.sourceDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.targetDBSnapshotIdentifier() == null ? 0 : this.targetDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.copyTags() == null ? 0 : this.copyTags().hashCode());
        hashCode = 31 * hashCode + (this.preSignedUrl() == null ? 0 : this.preSignedUrl().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.sourceRegion() == null ? 0 : this.sourceRegion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBSnapshotRequest)) {
            return false;
        }
        CopyDBSnapshotRequest other = (CopyDBSnapshotRequest)((Object)obj);
        if (other.sourceDBSnapshotIdentifier() == null ^ this.sourceDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.sourceDBSnapshotIdentifier() != null && !other.sourceDBSnapshotIdentifier().equals(this.sourceDBSnapshotIdentifier())) {
            return false;
        }
        if (other.targetDBSnapshotIdentifier() == null ^ this.targetDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.targetDBSnapshotIdentifier() != null && !other.targetDBSnapshotIdentifier().equals(this.targetDBSnapshotIdentifier())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.copyTags() == null ^ this.copyTags() == null) {
            return false;
        }
        if (other.copyTags() != null && !other.copyTags().equals(this.copyTags())) {
            return false;
        }
        if (other.preSignedUrl() == null ^ this.preSignedUrl() == null) {
            return false;
        }
        if (other.preSignedUrl() != null && !other.preSignedUrl().equals(this.preSignedUrl())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.sourceRegion() == null ^ this.sourceRegion() == null) {
            return false;
        }
        return other.sourceRegion() == null || other.sourceRegion().equals(this.sourceRegion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceDBSnapshotIdentifier() != null) {
            sb.append("SourceDBSnapshotIdentifier: ").append(this.sourceDBSnapshotIdentifier()).append(",");
        }
        if (this.targetDBSnapshotIdentifier() != null) {
            sb.append("TargetDBSnapshotIdentifier: ").append(this.targetDBSnapshotIdentifier()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.copyTags() != null) {
            sb.append("CopyTags: ").append(this.copyTags()).append(",");
        }
        if (this.preSignedUrl() != null) {
            sb.append("PreSignedUrl: ").append(this.preSignedUrl()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceDBSnapshotIdentifier;
        private String targetDBSnapshotIdentifier;
        private String kmsKeyId;
        private List<Tag> tags;
        private Boolean copyTags;
        private String preSignedUrl;
        private String optionGroupName;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDBSnapshotRequest model) {
            this.setSourceDBSnapshotIdentifier(model.sourceDBSnapshotIdentifier);
            this.setTargetDBSnapshotIdentifier(model.targetDBSnapshotIdentifier);
            this.setKmsKeyId(model.kmsKeyId);
            this.setTags(model.tags);
            this.setCopyTags(model.copyTags);
            this.setPreSignedUrl(model.preSignedUrl);
            this.setOptionGroupName(model.optionGroupName);
            this.setSourceRegion(model.sourceRegion);
        }

        public final String getSourceDBSnapshotIdentifier() {
            return this.sourceDBSnapshotIdentifier;
        }

        @Override
        public final Builder sourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
            return this;
        }

        public final void setSourceDBSnapshotIdentifier(String sourceDBSnapshotIdentifier) {
            this.sourceDBSnapshotIdentifier = sourceDBSnapshotIdentifier;
        }

        public final String getTargetDBSnapshotIdentifier() {
            return this.targetDBSnapshotIdentifier;
        }

        @Override
        public final Builder targetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
            this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
            return this;
        }

        public final void setTargetDBSnapshotIdentifier(String targetDBSnapshotIdentifier) {
            this.targetDBSnapshotIdentifier = targetDBSnapshotIdentifier;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public CopyDBSnapshotRequest build() {
            return new CopyDBSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyDBSnapshotRequest> {
        public Builder sourceDBSnapshotIdentifier(String var1);

        public Builder targetDBSnapshotIdentifier(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder copyTags(Boolean var1);

        public Builder preSignedUrl(String var1);

        public Builder optionGroupName(String var1);

        public Builder sourceRegion(String var1);
    }
}

