/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbClusterSnapshotRequestMarshaller
implements Marshaller<Request<CreateDbClusterSnapshotRequest>, CreateDbClusterSnapshotRequest> {
    public Request<CreateDbClusterSnapshotRequest> marshall(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        if (createDbClusterSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbClusterSnapshotRequest, "RdsClient");
        request.addParameter("Action", "CreateDBClusterSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbClusterSnapshotRequest.dbClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringConversion.fromString((String)createDbClusterSnapshotRequest.dbClusterSnapshotIdentifier()));
        }
        if (createDbClusterSnapshotRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)createDbClusterSnapshotRequest.dbClusterIdentifier()));
        }
        if (createDbClusterSnapshotRequest.tags().isEmpty() && !(createDbClusterSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbClusterSnapshotRequest.tags().isEmpty() && !(createDbClusterSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbClusterSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

