/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest;

public class AuthorizeDbSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeDbSecurityGroupIngressRequest>, AuthorizeDbSecurityGroupIngressRequest> {
    public Request<AuthorizeDbSecurityGroupIngressRequest> marshall(AuthorizeDbSecurityGroupIngressRequest authorizeDbSecurityGroupIngressRequest) {
        if (authorizeDbSecurityGroupIngressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)authorizeDbSecurityGroupIngressRequest, "RdsClient");
        request.addParameter("Action", "AuthorizeDBSecurityGroupIngress");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeDbSecurityGroupIngressRequest.dbSecurityGroupName() != null) {
            request.addParameter("DBSecurityGroupName", StringConversion.fromString((String)authorizeDbSecurityGroupIngressRequest.dbSecurityGroupName()));
        }
        if (authorizeDbSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringConversion.fromString((String)authorizeDbSecurityGroupIngressRequest.cidrip()));
        }
        if (authorizeDbSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringConversion.fromString((String)authorizeDbSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (authorizeDbSecurityGroupIngressRequest.ec2SecurityGroupId() != null) {
            request.addParameter("EC2SecurityGroupId", StringConversion.fromString((String)authorizeDbSecurityGroupIngressRequest.ec2SecurityGroupId()));
        }
        if (authorizeDbSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringConversion.fromString((String)authorizeDbSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

