/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCurrentDbClusterCapacityRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyCurrentDbClusterCapacityRequest> {
    private final String dbClusterIdentifier;
    private final Integer capacity;
    private final Integer secondsBeforeTimeout;
    private final String timeoutAction;

    private ModifyCurrentDbClusterCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.capacity = builder.capacity;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
        this.timeoutAction = builder.timeoutAction;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public Integer secondsBeforeTimeout() {
        return this.secondsBeforeTimeout;
    }

    public String timeoutAction() {
        return this.timeoutAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsBeforeTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutAction());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCurrentDbClusterCapacityRequest)) {
            return false;
        }
        ModifyCurrentDbClusterCapacityRequest other = (ModifyCurrentDbClusterCapacityRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.capacity(), other.capacity()) && Objects.equals(this.secondsBeforeTimeout(), other.secondsBeforeTimeout()) && Objects.equals(this.timeoutAction(), other.timeoutAction());
    }

    public String toString() {
        return ToString.builder((String)"ModifyCurrentDbClusterCapacityRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("Capacity", (Object)this.capacity()).add("SecondsBeforeTimeout", (Object)this.secondsBeforeTimeout()).add("TimeoutAction", (Object)this.timeoutAction()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "Capacity": {
                return Optional.ofNullable(clazz.cast(this.capacity()));
            }
            case "SecondsBeforeTimeout": {
                return Optional.ofNullable(clazz.cast(this.secondsBeforeTimeout()));
            }
            case "TimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.timeoutAction()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private Integer capacity;
        private Integer secondsBeforeTimeout;
        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCurrentDbClusterCapacityRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.capacity(model.capacity);
            this.secondsBeforeTimeout(model.secondsBeforeTimeout);
            this.timeoutAction(model.timeoutAction);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Integer getCapacity() {
            return this.capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        public final Integer getSecondsBeforeTimeout() {
            return this.secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCurrentDbClusterCapacityRequest build() {
            return new ModifyCurrentDbClusterCapacityRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, ModifyCurrentDbClusterCapacityRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder capacity(Integer var1);

        public Builder secondsBeforeTimeout(Integer var1);

        public Builder timeoutAction(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

