/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverDbClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, FailoverDbClusterRequest> {
    private final String dbClusterIdentifier;
    private final String targetDBInstanceIdentifier;

    private FailoverDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.targetDBInstanceIdentifier = builder.targetDBInstanceIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String targetDBInstanceIdentifier() {
        return this.targetDBInstanceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBInstanceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverDbClusterRequest)) {
            return false;
        }
        FailoverDbClusterRequest other = (FailoverDbClusterRequest)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.targetDBInstanceIdentifier(), other.targetDBInstanceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"FailoverDbClusterRequest").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("TargetDBInstanceIdentifier", (Object)this.targetDBInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "TargetDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBInstanceIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String targetDBInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverDbClusterRequest model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.targetDBInstanceIdentifier(model.targetDBInstanceIdentifier);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getTargetDBInstanceIdentifier() {
            return this.targetDBInstanceIdentifier;
        }

        @Override
        public final Builder targetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
            return this;
        }

        public final void setTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public FailoverDbClusterRequest build() {
            return new FailoverDbClusterRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, FailoverDbClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder targetDBInstanceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

