/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressRequest;

public class RevokeDbSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeDbSecurityGroupIngressRequest>, RevokeDbSecurityGroupIngressRequest> {
    public Request<RevokeDbSecurityGroupIngressRequest> marshall(RevokeDbSecurityGroupIngressRequest revokeDbSecurityGroupIngressRequest) {
        if (revokeDbSecurityGroupIngressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)revokeDbSecurityGroupIngressRequest, "RdsClient");
        request.addParameter("Action", "RevokeDBSecurityGroupIngress");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeDbSecurityGroupIngressRequest.dbSecurityGroupName() != null) {
            request.addParameter("DBSecurityGroupName", StringConversion.fromString((String)revokeDbSecurityGroupIngressRequest.dbSecurityGroupName()));
        }
        if (revokeDbSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringConversion.fromString((String)revokeDbSecurityGroupIngressRequest.cidrip()));
        }
        if (revokeDbSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringConversion.fromString((String)revokeDbSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (revokeDbSecurityGroupIngressRequest.ec2SecurityGroupId() != null) {
            request.addParameter("EC2SecurityGroupId", StringConversion.fromString((String)revokeDbSecurityGroupIngressRequest.ec2SecurityGroupId()));
        }
        if (revokeDbSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringConversion.fromString((String)revokeDbSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

