/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDbClusterToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDbClusterToPointInTimeRequest>, RestoreDbClusterToPointInTimeRequest> {
    public Request<RestoreDbClusterToPointInTimeRequest> marshall(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) {
        if (restoreDbClusterToPointInTimeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDbClusterToPointInTimeRequest, "RdsClient");
        request.addParameter("Action", "RestoreDBClusterToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDbClusterToPointInTimeRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)restoreDbClusterToPointInTimeRequest.dbClusterIdentifier()));
        }
        if (restoreDbClusterToPointInTimeRequest.restoreType() != null) {
            request.addParameter("RestoreType", StringConversion.fromString((String)restoreDbClusterToPointInTimeRequest.restoreType()));
        }
        if (restoreDbClusterToPointInTimeRequest.sourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringConversion.fromString((String)restoreDbClusterToPointInTimeRequest.sourceDBClusterIdentifier()));
        }
        if (restoreDbClusterToPointInTimeRequest.restoreToTime() != null) {
            request.addParameter("RestoreToTime", StringConversion.fromInstant((Instant)restoreDbClusterToPointInTimeRequest.restoreToTime()));
        }
        if (restoreDbClusterToPointInTimeRequest.useLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringConversion.fromBoolean((Boolean)restoreDbClusterToPointInTimeRequest.useLatestRestorableTime()));
        }
        if (restoreDbClusterToPointInTimeRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreDbClusterToPointInTimeRequest.port()));
        }
        if (restoreDbClusterToPointInTimeRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)restoreDbClusterToPointInTimeRequest.dbSubnetGroupName()));
        }
        if (restoreDbClusterToPointInTimeRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)restoreDbClusterToPointInTimeRequest.optionGroupName()));
        }
        if (restoreDbClusterToPointInTimeRequest.vpcSecurityGroupIds().isEmpty() && !(restoreDbClusterToPointInTimeRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!restoreDbClusterToPointInTimeRequest.vpcSecurityGroupIds().isEmpty() && !(restoreDbClusterToPointInTimeRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = restoreDbClusterToPointInTimeRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDbClusterToPointInTimeRequest.tags().isEmpty() && !(restoreDbClusterToPointInTimeRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!restoreDbClusterToPointInTimeRequest.tags().isEmpty() && !(restoreDbClusterToPointInTimeRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = restoreDbClusterToPointInTimeRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDbClusterToPointInTimeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)restoreDbClusterToPointInTimeRequest.kmsKeyId()));
        }
        if (restoreDbClusterToPointInTimeRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)restoreDbClusterToPointInTimeRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

