/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeReservedDbInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedDbInstancesOfferingsRequest>, DescribeReservedDbInstancesOfferingsRequest> {
    public Request<DescribeReservedDbInstancesOfferingsRequest> marshall(DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest) {
        if (describeReservedDbInstancesOfferingsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedDbInstancesOfferingsRequest, "RdsClient");
        request.addParameter("Action", "DescribeReservedDBInstancesOfferings");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedDbInstancesOfferingsRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringConversion.fromString((String)describeReservedDbInstancesOfferingsRequest.reservedDBInstancesOfferingId()));
        }
        if (describeReservedDbInstancesOfferingsRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)describeReservedDbInstancesOfferingsRequest.dbInstanceClass()));
        }
        if (describeReservedDbInstancesOfferingsRequest.duration() != null) {
            request.addParameter("Duration", StringConversion.fromString((String)describeReservedDbInstancesOfferingsRequest.duration()));
        }
        if (describeReservedDbInstancesOfferingsRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringConversion.fromString((String)describeReservedDbInstancesOfferingsRequest.productDescription()));
        }
        if (describeReservedDbInstancesOfferingsRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringConversion.fromString((String)describeReservedDbInstancesOfferingsRequest.offeringType()));
        }
        if (describeReservedDbInstancesOfferingsRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)describeReservedDbInstancesOfferingsRequest.multiAZ()));
        }
        if (describeReservedDbInstancesOfferingsRequest.filters().isEmpty() && !(describeReservedDbInstancesOfferingsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeReservedDbInstancesOfferingsRequest.filters().isEmpty() && !(describeReservedDbInstancesOfferingsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeReservedDbInstancesOfferingsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedDbInstancesOfferingsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeReservedDbInstancesOfferingsRequest.maxRecords()));
        }
        if (describeReservedDbInstancesOfferingsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeReservedDbInstancesOfferingsRequest.marker()));
        }
        return request;
    }
}

