/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeOptionGroupsRequestMarshaller
implements Marshaller<Request<DescribeOptionGroupsRequest>, DescribeOptionGroupsRequest> {
    public Request<DescribeOptionGroupsRequest> marshall(DescribeOptionGroupsRequest describeOptionGroupsRequest) {
        if (describeOptionGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeOptionGroupsRequest, "RdsClient");
        request.addParameter("Action", "DescribeOptionGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOptionGroupsRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)describeOptionGroupsRequest.optionGroupName()));
        }
        if (describeOptionGroupsRequest.filters().isEmpty() && !(describeOptionGroupsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeOptionGroupsRequest.filters().isEmpty() && !(describeOptionGroupsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeOptionGroupsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOptionGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeOptionGroupsRequest.marker()));
        }
        if (describeOptionGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeOptionGroupsRequest.maxRecords()));
        }
        if (describeOptionGroupsRequest.engineName() != null) {
            request.addParameter("EngineName", StringConversion.fromString((String)describeOptionGroupsRequest.engineName()));
        }
        if (describeOptionGroupsRequest.majorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringConversion.fromString((String)describeOptionGroupsRequest.majorEngineVersion()));
        }
        return request;
    }
}

