/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeDbSnapshotsRequest>, DescribeDbSnapshotsRequest> {
    public Request<DescribeDbSnapshotsRequest> marshall(DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        if (describeDbSnapshotsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbSnapshotsRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBSnapshots");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbSnapshotsRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)describeDbSnapshotsRequest.dbInstanceIdentifier()));
        }
        if (describeDbSnapshotsRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)describeDbSnapshotsRequest.dbSnapshotIdentifier()));
        }
        if (describeDbSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringConversion.fromString((String)describeDbSnapshotsRequest.snapshotType()));
        }
        if (describeDbSnapshotsRequest.filters().isEmpty() && !(describeDbSnapshotsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbSnapshotsRequest.filters().isEmpty() && !(describeDbSnapshotsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbSnapshotsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbSnapshotsRequest.maxRecords()));
        }
        if (describeDbSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbSnapshotsRequest.marker()));
        }
        if (describeDbSnapshotsRequest.includeShared() != null) {
            request.addParameter("IncludeShared", StringConversion.fromBoolean((Boolean)describeDbSnapshotsRequest.includeShared()));
        }
        if (describeDbSnapshotsRequest.includePublic() != null) {
            request.addParameter("IncludePublic", StringConversion.fromBoolean((Boolean)describeDbSnapshotsRequest.includePublic()));
        }
        return request;
    }
}

