/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbSubnetGroupRequestMarshaller
implements Marshaller<Request<CreateDbSubnetGroupRequest>, CreateDbSubnetGroupRequest> {
    public Request<CreateDbSubnetGroupRequest> marshall(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        if (createDbSubnetGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbSubnetGroupRequest, "RdsClient");
        request.addParameter("Action", "CreateDBSubnetGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbSubnetGroupRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)createDbSubnetGroupRequest.dbSubnetGroupName()));
        }
        if (createDbSubnetGroupRequest.dbSubnetGroupDescription() != null) {
            request.addParameter("DBSubnetGroupDescription", StringConversion.fromString((String)createDbSubnetGroupRequest.dbSubnetGroupDescription()));
        }
        if (createDbSubnetGroupRequest.subnetIds().isEmpty() && !(createDbSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SubnetIds", "");
        } else if (!createDbSubnetGroupRequest.subnetIds().isEmpty() && !(createDbSubnetGroupRequest.subnetIds() instanceof SdkAutoConstructList)) {
            List<String> subnetIdsList = createDbSubnetGroupRequest.subnetIds();
            int subnetIdsListIndex = 1;
            for (String subnetIdsListValue : subnetIdsList) {
                if (subnetIdsListValue != null) {
                    request.addParameter("SubnetIds.SubnetIdentifier." + subnetIdsListIndex, StringConversion.fromString((String)subnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (createDbSubnetGroupRequest.tags().isEmpty() && !(createDbSubnetGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbSubnetGroupRequest.tags().isEmpty() && !(createDbSubnetGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbSubnetGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

