/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CopyDbClusterParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDbClusterParameterGroupRequest>, CopyDbClusterParameterGroupRequest> {
    public Request<CopyDbClusterParameterGroupRequest> marshall(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        if (copyDbClusterParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyDbClusterParameterGroupRequest, "RdsClient");
        request.addParameter("Action", "CopyDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDbClusterParameterGroupRequest.sourceDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBClusterParameterGroupIdentifier", StringConversion.fromString((String)copyDbClusterParameterGroupRequest.sourceDBClusterParameterGroupIdentifier()));
        }
        if (copyDbClusterParameterGroupRequest.targetDBClusterParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBClusterParameterGroupIdentifier", StringConversion.fromString((String)copyDbClusterParameterGroupRequest.targetDBClusterParameterGroupIdentifier()));
        }
        if (copyDbClusterParameterGroupRequest.targetDBClusterParameterGroupDescription() != null) {
            request.addParameter("TargetDBClusterParameterGroupDescription", StringConversion.fromString((String)copyDbClusterParameterGroupRequest.targetDBClusterParameterGroupDescription()));
        }
        if (copyDbClusterParameterGroupRequest.tags().isEmpty() && !(copyDbClusterParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!copyDbClusterParameterGroupRequest.tags().isEmpty() && !(copyDbClusterParameterGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = copyDbClusterParameterGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

