/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse;

public class DescribeDBSubnetGroupsIterable
implements SdkIterable<DescribeDbSubnetGroupsResponse> {
    private final RdsClient client;
    private final DescribeDbSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSubnetGroupsIterable(RdsClient client, DescribeDbSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeDbSubnetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBSubnetGroup> dbSubnetGroups() {
        Function<DescribeDbSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSubnetGroups() != null) {
                return response.dbSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBSubnetGroupsIterable resume(DescribeDbSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSubnetGroupsIterable(this.client, (DescribeDbSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSubnetGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbSubnetGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbSubnetGroupsResponse> {
        private DescribeDbSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeDbSubnetGroupsResponse nextPage(DescribeDbSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSubnetGroupsIterable.this.client.describeDBSubnetGroups(DescribeDBSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeDBSubnetGroupsIterable.this.client.describeDBSubnetGroups((DescribeDbSubnetGroupsRequest)((Object)DescribeDBSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

