/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionVersion
implements ToCopyableBuilder<Builder, OptionVersion> {
    private final String version;
    private final Boolean isDefault;

    private OptionVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.isDefault = builder.isDefault;
    }

    public String version() {
        return this.version;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionVersion)) {
            return false;
        }
        OptionVersion other = (OptionVersion)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.isDefault(), other.isDefault());
    }

    public String toString() {
        return ToString.builder((String)"OptionVersion").add("Version", (Object)this.version()).add("IsDefault", (Object)this.isDefault()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionVersion model) {
            this.version(model.version);
            this.isDefault(model.isDefault);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public OptionVersion build() {
            return new OptionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionVersion> {
        public Builder version(String var1);

        public Builder isDefault(Boolean var1);
    }
}

