/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption;

public class DescribeOrderableDBInstanceOptionsPublisher
implements SdkPublisher<DescribeOrderableDBInstanceOptionsResponse> {
    private final RDSAsyncClient client;
    private final DescribeOrderableDBInstanceOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrderableDBInstanceOptionsPublisher(RDSAsyncClient client, DescribeOrderableDBInstanceOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrderableDBInstanceOptionsPublisher(RDSAsyncClient client, DescribeOrderableDBInstanceOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrderableDBInstanceOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrderableDBInstanceOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        Function<DescribeOrderableDBInstanceOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableDBInstanceOptions() != null) {
                return response.orderableDBInstanceOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeOrderableDBInstanceOptionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeOrderableDBInstanceOptionsPublisher resume(DescribeOrderableDBInstanceOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOrderableDBInstanceOptionsPublisher(this.client, (DescribeOrderableDBInstanceOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOrderableDBInstanceOptionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeOrderableDBInstanceOptionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeOrderableDBInstanceOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeOrderableDBInstanceOptionsResponse> {
        private DescribeOrderableDBInstanceOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableDBInstanceOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeOrderableDBInstanceOptionsResponse> nextPage(DescribeOrderableDBInstanceOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableDBInstanceOptionsPublisher.this.client.describeOrderableDBInstanceOptions(DescribeOrderableDBInstanceOptionsPublisher.this.firstRequest);
            }
            return DescribeOrderableDBInstanceOptionsPublisher.this.client.describeOrderableDBInstanceOptions((DescribeOrderableDBInstanceOptionsRequest)((Object)DescribeOrderableDBInstanceOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

