/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.Event;

public class DescribeEventsIterable
implements SdkIterable<DescribeEventsResponse> {
    private final RDSClient client;
    private final DescribeEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventsIterable(RDSClient client, DescribeEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public Iterator<DescribeEventsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Event> events() {
        Function<DescribeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeEventsIterable resume(DescribeEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventsIterable(this.client, (DescribeEventsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEventsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEventsResponseFetcher
    implements SyncPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeEventsResponse nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsIterable.this.client.describeEvents(DescribeEventsIterable.this.firstRequest);
            }
            return DescribeEventsIterable.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

