/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersResponse;
import software.amazon.awssdk.services.rds.model.Parameter;

public class DescribeDBParametersIterable
implements SdkIterable<DescribeDBParametersResponse> {
    private final RDSClient client;
    private final DescribeDBParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBParametersIterable(RDSClient client, DescribeDBParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBParametersResponseFetcher();
    }

    public Iterator<DescribeDBParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeDBParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBParametersIterable resume(DescribeDBParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBParametersIterable(this.client, (DescribeDBParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBParametersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBParametersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBParametersResponseFetcher
    implements SyncPageFetcher<DescribeDBParametersResponse> {
        private DescribeDBParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBParametersResponse nextPage(DescribeDBParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParametersIterable.this.client.describeDBParameters(DescribeDBParametersIterable.this.firstRequest);
            }
            return DescribeDBParametersIterable.this.client.describeDBParameters((DescribeDBParametersRequest)((Object)DescribeDBParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

