/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesResponse;

public class DescribeDBLogFilesPublisher
implements SdkPublisher<DescribeDBLogFilesResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBLogFilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBLogFilesPublisher(RDSAsyncClient client, DescribeDBLogFilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBLogFilesPublisher(RDSAsyncClient client, DescribeDBLogFilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBLogFilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBLogFilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DescribeDBLogFilesDetails> describeDBLogFiles() {
        Function<DescribeDBLogFilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.describeDBLogFiles() != null) {
                return response.describeDBLogFiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBLogFilesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBLogFilesPublisher resume(DescribeDBLogFilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBLogFilesPublisher(this.client, (DescribeDBLogFilesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBLogFilesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBLogFilesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBLogFilesResponseFetcher
    implements AsyncPageFetcher<DescribeDBLogFilesResponse> {
        private DescribeDBLogFilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBLogFilesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBLogFilesResponse> nextPage(DescribeDBLogFilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBLogFilesPublisher.this.client.describeDBLogFiles(DescribeDBLogFilesPublisher.this.firstRequest);
            }
            return DescribeDBLogFilesPublisher.this.client.describeDBLogFiles((DescribeDBLogFilesRequest)((Object)DescribeDBLogFilesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

