/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedDBInstancesRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, DescribeReservedDBInstancesRequest> {
    private final String reservedDBInstanceId;
    private final String reservedDBInstancesOfferingId;
    private final String dbInstanceClass;
    private final String duration;
    private final String productDescription;
    private final String offeringType;
    private final Boolean multiAZ;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeReservedDBInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String reservedDBInstanceId() {
        return this.reservedDBInstanceId;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public String duration() {
        return this.duration;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDBInstancesRequest)) {
            return false;
        }
        DescribeReservedDBInstancesRequest other = (DescribeReservedDBInstancesRequest)((Object)obj);
        return Objects.equals(this.reservedDBInstanceId(), other.reservedDBInstanceId()) && Objects.equals(this.reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedDBInstancesRequest").add("ReservedDBInstanceId", (Object)this.reservedDBInstanceId()).add("ReservedDBInstancesOfferingId", (Object)this.reservedDBInstancesOfferingId()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Duration", (Object)this.duration()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("MultiAZ", (Object)this.multiAZ()).add("Filters", this.filters()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstanceId": {
                return Optional.of(clazz.cast(this.reservedDBInstanceId()));
            }
            case "ReservedDBInstancesOfferingId": {
                return Optional.of(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "DBInstanceClass": {
                return Optional.of(clazz.cast(this.dbInstanceClass()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "ProductDescription": {
                return Optional.of(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.of(clazz.cast(this.offeringType()));
            }
            case "MultiAZ": {
                return Optional.of(clazz.cast(this.multiAZ()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String reservedDBInstanceId;
        private String reservedDBInstancesOfferingId;
        private String dbInstanceClass;
        private String duration;
        private String productDescription;
        private String offeringType;
        private Boolean multiAZ;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDBInstancesRequest model) {
            super(model);
            this.reservedDBInstanceId(model.reservedDBInstanceId);
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.dbInstanceClass(model.dbInstanceClass);
            this.duration(model.duration);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.multiAZ(model.multiAZ);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getReservedDBInstanceId() {
            return this.reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedDBInstancesRequest build() {
            return new DescribeReservedDBInstancesRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, DescribeReservedDBInstancesRequest> {
        public Builder reservedDBInstanceId(String var1);

        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder duration(String var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

