/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedDBInstancesOfferingsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribeReservedDBInstancesOfferingsResponse> {
    private final String marker;
    private final List<ReservedDBInstancesOffering> reservedDBInstancesOfferings;

    private DescribeReservedDBInstancesOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedDBInstancesOfferings = builder.reservedDBInstancesOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        return this.reservedDBInstancesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDBInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedDBInstancesOfferingsResponse other = (DescribeReservedDBInstancesOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedDBInstancesOfferings(), other.reservedDBInstancesOfferings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedDBInstancesOfferingsResponse").add("Marker", (Object)this.marker()).add("ReservedDBInstancesOfferings", this.reservedDBInstancesOfferings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReservedDBInstancesOfferings": {
                return Optional.of(clazz.cast(this.reservedDBInstancesOfferings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedDBInstancesOffering> reservedDBInstancesOfferings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDBInstancesOfferingsResponse model) {
            super(model);
            this.marker(model.marker);
            this.reservedDBInstancesOfferings(model.reservedDBInstancesOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstancesOffering.Builder> getReservedDBInstancesOfferings() {
            return this.reservedDBInstancesOfferings != null ? (Collection)this.reservedDBInstancesOfferings.stream().map(ReservedDBInstancesOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings = ReservedDBInstancesOfferingListCopier.copy(reservedDBInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstancesOfferings(ReservedDBInstancesOffering ... reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings(Arrays.asList(reservedDBInstancesOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstancesOfferings(Consumer<ReservedDBInstancesOffering.Builder> ... reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings(Stream.of(reservedDBInstancesOfferings).map(c -> (ReservedDBInstancesOffering)((ReservedDBInstancesOffering.Builder)ReservedDBInstancesOffering.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering.BuilderImpl> reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings = ReservedDBInstancesOfferingListCopier.copyFromBuilder(reservedDBInstancesOfferings);
        }

        @Override
        public DescribeReservedDBInstancesOfferingsResponse build() {
            return new DescribeReservedDBInstancesOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribeReservedDBInstancesOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> var1);

        public Builder reservedDBInstancesOfferings(ReservedDBInstancesOffering ... var1);

        public Builder reservedDBInstancesOfferings(Consumer<ReservedDBInstancesOffering.Builder> ... var1);
    }
}

