/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.CharacterSet;
import software.amazon.awssdk.services.rds.model.SupportedCharacterSetsListCopier;
import software.amazon.awssdk.services.rds.model.SupportedTimezonesListCopier;
import software.amazon.awssdk.services.rds.model.Timezone;
import software.amazon.awssdk.services.rds.model.UpgradeTarget;
import software.amazon.awssdk.services.rds.model.ValidUpgradeTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBEngineVersion
implements ToCopyableBuilder<Builder, DBEngineVersion> {
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final String dbEngineDescription;
    private final String dbEngineVersionDescription;
    private final CharacterSet defaultCharacterSet;
    private final List<CharacterSet> supportedCharacterSets;
    private final List<UpgradeTarget> validUpgradeTarget;
    private final List<Timezone> supportedTimezones;

    private DBEngineVersion(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.dbEngineDescription = builder.dbEngineDescription;
        this.dbEngineVersionDescription = builder.dbEngineVersionDescription;
        this.defaultCharacterSet = builder.defaultCharacterSet;
        this.supportedCharacterSets = builder.supportedCharacterSets;
        this.validUpgradeTarget = builder.validUpgradeTarget;
        this.supportedTimezones = builder.supportedTimezones;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public String dbEngineDescription() {
        return this.dbEngineDescription;
    }

    public String dbEngineVersionDescription() {
        return this.dbEngineVersionDescription;
    }

    public CharacterSet defaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public List<CharacterSet> supportedCharacterSets() {
        return this.supportedCharacterSets;
    }

    public List<UpgradeTarget> validUpgradeTarget() {
        return this.validUpgradeTarget;
    }

    public List<Timezone> supportedTimezones() {
        return this.supportedTimezones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCharacterSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedCharacterSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.validUpgradeTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedTimezones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBEngineVersion)) {
            return false;
        }
        DBEngineVersion other = (DBEngineVersion)obj;
        return Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.dbEngineDescription(), other.dbEngineDescription()) && Objects.equals(this.dbEngineVersionDescription(), other.dbEngineVersionDescription()) && Objects.equals(this.defaultCharacterSet(), other.defaultCharacterSet()) && Objects.equals(this.supportedCharacterSets(), other.supportedCharacterSets()) && Objects.equals(this.validUpgradeTarget(), other.validUpgradeTarget()) && Objects.equals(this.supportedTimezones(), other.supportedTimezones());
    }

    public String toString() {
        return ToString.builder((String)"DBEngineVersion").add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("DBEngineDescription", (Object)this.dbEngineDescription()).add("DBEngineVersionDescription", (Object)this.dbEngineVersionDescription()).add("DefaultCharacterSet", (Object)this.defaultCharacterSet()).add("SupportedCharacterSets", this.supportedCharacterSets()).add("ValidUpgradeTarget", this.validUpgradeTarget()).add("SupportedTimezones", this.supportedTimezones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "DBEngineDescription": {
                return Optional.of(clazz.cast(this.dbEngineDescription()));
            }
            case "DBEngineVersionDescription": {
                return Optional.of(clazz.cast(this.dbEngineVersionDescription()));
            }
            case "DefaultCharacterSet": {
                return Optional.of(clazz.cast(this.defaultCharacterSet()));
            }
            case "SupportedCharacterSets": {
                return Optional.of(clazz.cast(this.supportedCharacterSets()));
            }
            case "ValidUpgradeTarget": {
                return Optional.of(clazz.cast(this.validUpgradeTarget()));
            }
            case "SupportedTimezones": {
                return Optional.of(clazz.cast(this.supportedTimezones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private String dbEngineDescription;
        private String dbEngineVersionDescription;
        private CharacterSet defaultCharacterSet;
        private List<CharacterSet> supportedCharacterSets;
        private List<UpgradeTarget> validUpgradeTarget;
        private List<Timezone> supportedTimezones;

        private BuilderImpl() {
        }

        private BuilderImpl(DBEngineVersion model) {
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.dbEngineDescription(model.dbEngineDescription);
            this.dbEngineVersionDescription(model.dbEngineVersionDescription);
            this.defaultCharacterSet(model.defaultCharacterSet);
            this.supportedCharacterSets(model.supportedCharacterSets);
            this.validUpgradeTarget(model.validUpgradeTarget);
            this.supportedTimezones(model.supportedTimezones);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDBEngineDescription() {
            return this.dbEngineDescription;
        }

        @Override
        public final Builder dbEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
            return this;
        }

        public final void setDBEngineDescription(String dbEngineDescription) {
            this.dbEngineDescription = dbEngineDescription;
        }

        public final String getDBEngineVersionDescription() {
            return this.dbEngineVersionDescription;
        }

        @Override
        public final Builder dbEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
            return this;
        }

        public final void setDBEngineVersionDescription(String dbEngineVersionDescription) {
            this.dbEngineVersionDescription = dbEngineVersionDescription;
        }

        public final CharacterSet.Builder getDefaultCharacterSet() {
            return this.defaultCharacterSet != null ? this.defaultCharacterSet.toBuilder() : null;
        }

        @Override
        public final Builder defaultCharacterSet(CharacterSet defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet;
            return this;
        }

        public final void setDefaultCharacterSet(CharacterSet.BuilderImpl defaultCharacterSet) {
            this.defaultCharacterSet = defaultCharacterSet != null ? defaultCharacterSet.build() : null;
        }

        public final Collection<CharacterSet.Builder> getSupportedCharacterSets() {
            return this.supportedCharacterSets != null ? (Collection)this.supportedCharacterSets.stream().map(CharacterSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedCharacterSets(Collection<CharacterSet> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copy(supportedCharacterSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(CharacterSet ... supportedCharacterSets) {
            this.supportedCharacterSets(Arrays.asList(supportedCharacterSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... supportedCharacterSets) {
            this.supportedCharacterSets(Stream.of(supportedCharacterSets).map(c -> (CharacterSet)((CharacterSet.Builder)CharacterSet.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedCharacterSets(Collection<CharacterSet.BuilderImpl> supportedCharacterSets) {
            this.supportedCharacterSets = SupportedCharacterSetsListCopier.copyFromBuilder(supportedCharacterSets);
        }

        public final Collection<UpgradeTarget.Builder> getValidUpgradeTarget() {
            return this.validUpgradeTarget != null ? (Collection)this.validUpgradeTarget.stream().map(UpgradeTarget::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validUpgradeTarget(Collection<UpgradeTarget> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copy(validUpgradeTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(UpgradeTarget ... validUpgradeTarget) {
            this.validUpgradeTarget(Arrays.asList(validUpgradeTarget));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... validUpgradeTarget) {
            this.validUpgradeTarget(Stream.of(validUpgradeTarget).map(c -> (UpgradeTarget)((UpgradeTarget.Builder)UpgradeTarget.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidUpgradeTarget(Collection<UpgradeTarget.BuilderImpl> validUpgradeTarget) {
            this.validUpgradeTarget = ValidUpgradeTargetListCopier.copyFromBuilder(validUpgradeTarget);
        }

        public final Collection<Timezone.Builder> getSupportedTimezones() {
            return this.supportedTimezones != null ? (Collection)this.supportedTimezones.stream().map(Timezone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedTimezones(Collection<Timezone> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copy(supportedTimezones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Timezone ... supportedTimezones) {
            this.supportedTimezones(Arrays.asList(supportedTimezones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTimezones(Consumer<Timezone.Builder> ... supportedTimezones) {
            this.supportedTimezones(Stream.of(supportedTimezones).map(c -> (Timezone)((Timezone.Builder)Timezone.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedTimezones(Collection<Timezone.BuilderImpl> supportedTimezones) {
            this.supportedTimezones = SupportedTimezonesListCopier.copyFromBuilder(supportedTimezones);
        }

        public DBEngineVersion build() {
            return new DBEngineVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBEngineVersion> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder dbEngineDescription(String var1);

        public Builder dbEngineVersionDescription(String var1);

        public Builder defaultCharacterSet(CharacterSet var1);

        default public Builder defaultCharacterSet(Consumer<CharacterSet.Builder> defaultCharacterSet) {
            return this.defaultCharacterSet((CharacterSet)((CharacterSet.Builder)CharacterSet.builder().apply(defaultCharacterSet)).build());
        }

        public Builder supportedCharacterSets(Collection<CharacterSet> var1);

        public Builder supportedCharacterSets(CharacterSet ... var1);

        public Builder supportedCharacterSets(Consumer<CharacterSet.Builder> ... var1);

        public Builder validUpgradeTarget(Collection<UpgradeTarget> var1);

        public Builder validUpgradeTarget(UpgradeTarget ... var1);

        public Builder validUpgradeTarget(Consumer<UpgradeTarget.Builder> ... var1);

        public Builder supportedTimezones(Collection<Timezone> var1);

        public Builder supportedTimezones(Timezone ... var1);

        public Builder supportedTimezones(Consumer<Timezone.Builder> ... var1);
    }
}

