/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.net.URI;
import java.util.Date;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.InterceptorContext;
import software.amazon.awssdk.core.util.AwsHostNameUtils;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

abstract class RdsPresignInterceptor<T extends RDSRequest>
implements ExecutionInterceptor {
    private static final String SERVICE_NAME = "rds";
    private static final String PARAM_SOURCE_REGION = "SourceRegion";
    private static final String PARAM_DESTINATION_REGION = "DestinationRegion";
    private static final String PARAM_PRESIGNED_URL = "PreSignedUrl";
    private final Class<T> requestClassToPreSign;
    private final Date signingOverrideDate;

    RdsPresignInterceptor(Class<T> requestClassToPreSign) {
        this(requestClassToPreSign, null);
    }

    RdsPresignInterceptor(Class<T> requestClassToPreSign, Date signingOverrideDate) {
        this.requestClassToPreSign = requestClassToPreSign;
        this.signingOverrideDate = signingOverrideDate != null ? new Date(signingOverrideDate.getTime()) : null;
    }

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (!this.requestClassToPreSign.isInstance(originalRequest)) {
            return request;
        }
        if (request.rawQueryParameters().containsKey(PARAM_PRESIGNED_URL)) {
            return request;
        }
        PresignableRequest presignableRequest = this.adaptRequest((RDSRequest)((Object)this.requestClassToPreSign.cast(originalRequest)));
        String sourceRegion = presignableRequest.getSourceRegion();
        if (sourceRegion == null) {
            return request;
        }
        String destinationRegion = AwsHostNameUtils.parseRegion((String)request.host(), (String)SERVICE_NAME);
        URI endpoint = this.createEndpoint(sourceRegion, SERVICE_NAME);
        Request<?> legacyRequest = presignableRequest.marshall();
        legacyRequest.setEndpoint(endpoint);
        SdkHttpFullRequest.Builder marshalledRequest = SdkHttpFullRequestAdapter.toMutableHttpFullRequest(legacyRequest);
        SdkHttpFullRequest requestToPresign = (SdkHttpFullRequest)marshalledRequest.encodedPath(SdkHttpUtils.appendUri((String)endpoint.getPath(), (String)marshalledRequest.encodedPath())).method(SdkHttpMethod.GET).rawQueryParameter(PARAM_DESTINATION_REGION, destinationRegion).removeQueryParameter(PARAM_SOURCE_REGION).build();
        InterceptorContext contextToSign = InterceptorContext.builder().request(context.request()).httpRequest(requestToPresign).build();
        requestToPresign = this.presignRequest((Context.BeforeTransmission)contextToSign, executionAttributes, sourceRegion);
        String presignedUrl = requestToPresign.getUri().toString();
        presignableRequest.setPreSignedUrl(presignedUrl);
        return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).rawQueryParameter(PARAM_PRESIGNED_URL, presignedUrl).removeQueryParameter(PARAM_SOURCE_REGION).build();
    }

    protected abstract PresignableRequest adaptRequest(T var1);

    private SdkHttpFullRequest presignRequest(Context.BeforeTransmission context, ExecutionAttributes attributes, String signingRegion) {
        Aws4Signer signer = this.createNewSignerWithRegion(signingRegion);
        return signer.presign(context, attributes, null);
    }

    private Aws4Signer createNewSignerWithRegion(String signingRegion) {
        Aws4Signer signer = new Aws4Signer(true);
        signer.setRegionName(signingRegion);
        signer.setServiceName(SERVICE_NAME);
        signer.setOverrideDate(this.signingOverrideDate);
        return signer;
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw new SdkClientException("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.");
        }
        return new DefaultServiceEndpointBuilder(SERVICE_NAME, Protocol.HTTPS.toString()).withRegion(region).getServiceEndpoint();
    }

    protected static interface PresignableRequest {
        public void setPreSignedUrl(String var1);

        public String getSourceRegion();

        public Request<?> marshall();
    }
}

