/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.RestoreDBClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class RestoreDBClusterToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDBClusterToPointInTimeRequest>, RestoreDBClusterToPointInTimeRequest> {
    public Request<RestoreDBClusterToPointInTimeRequest> marshall(RestoreDBClusterToPointInTimeRequest restoreDBClusterToPointInTimeRequest) {
        SdkInternalList tagsList;
        SdkInternalList vpcSecurityGroupIdsList;
        if (restoreDBClusterToPointInTimeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterToPointInTimeRequest, "RDSClient");
        request.addParameter("Action", "RestoreDBClusterToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBClusterToPointInTimeRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.dbClusterIdentifier()));
        }
        if (restoreDBClusterToPointInTimeRequest.restoreType() != null) {
            request.addParameter("RestoreType", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.restoreType()));
        }
        if (restoreDBClusterToPointInTimeRequest.sourceDBClusterIdentifier() != null) {
            request.addParameter("SourceDBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.sourceDBClusterIdentifier()));
        }
        if (restoreDBClusterToPointInTimeRequest.restoreToTime() != null) {
            request.addParameter("RestoreToTime", StringUtils.fromDate((Date)restoreDBClusterToPointInTimeRequest.restoreToTime()));
        }
        if (restoreDBClusterToPointInTimeRequest.useLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.useLatestRestorableTime()));
        }
        if (restoreDBClusterToPointInTimeRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterToPointInTimeRequest.port()));
        }
        if (restoreDBClusterToPointInTimeRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.dbSubnetGroupName()));
        }
        if (restoreDBClusterToPointInTimeRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.optionGroupName()));
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)restoreDBClusterToPointInTimeRequest.vpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)restoreDBClusterToPointInTimeRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBClusterToPointInTimeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterToPointInTimeRequest.kmsKeyId()));
        }
        if (restoreDBClusterToPointInTimeRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterToPointInTimeRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

