/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class PurchaseReservedDBInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedDBInstancesOfferingRequest>, PurchaseReservedDBInstancesOfferingRequest> {
    public Request<PurchaseReservedDBInstancesOfferingRequest> marshall(PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest) {
        SdkInternalList tagsList;
        if (purchaseReservedDBInstancesOfferingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseReservedDBInstancesOfferingRequest, "RDSClient");
        request.addParameter("Action", "PurchaseReservedDBInstancesOffering");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseReservedDBInstancesOfferingRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringUtils.fromString((String)purchaseReservedDBInstancesOfferingRequest.reservedDBInstancesOfferingId()));
        }
        if (purchaseReservedDBInstancesOfferingRequest.reservedDBInstanceId() != null) {
            request.addParameter("ReservedDBInstanceId", StringUtils.fromString((String)purchaseReservedDBInstancesOfferingRequest.reservedDBInstanceId()));
        }
        if (purchaseReservedDBInstancesOfferingRequest.dbInstanceCount() != null) {
            request.addParameter("DBInstanceCount", StringUtils.fromInteger((Integer)purchaseReservedDBInstancesOfferingRequest.dbInstanceCount()));
        }
        if (!(tagsList = (SdkInternalList)purchaseReservedDBInstancesOfferingRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

