/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.OptionConfiguration;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.transform.OptionSettingUnmarshaller;

public class OptionConfigurationUnmarshaller
implements Unmarshaller<OptionConfiguration, StaxUnmarshallerContext> {
    private static OptionConfigurationUnmarshaller INSTANCE;

    public OptionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        OptionConfiguration.Builder optionConfiguration = OptionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("OptionName", targetDepth)) {
                    optionConfiguration.optionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Port", targetDepth)) {
                    optionConfiguration.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionVersion", targetDepth)) {
                    optionConfiguration.optionVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSecurityGroupMemberships", targetDepth)) {
                    optionConfiguration.dbSecurityGroupMemberships(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("DBSecurityGroupMemberships/DBSecurityGroupName", targetDepth)) {
                    optionConfiguration.dbSecurityGroupMemberships(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroupMemberships", targetDepth)) {
                    optionConfiguration.vpcSecurityGroupMemberships(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroupMemberships/VpcSecurityGroupId", targetDepth)) {
                    optionConfiguration.vpcSecurityGroupMemberships(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionSettings", targetDepth)) {
                    optionConfiguration.optionSettings(new ArrayList<OptionSetting>());
                    continue;
                }
                if (!context.testExpression("OptionSettings/OptionSetting", targetDepth)) continue;
                optionConfiguration.optionSettings(OptionSettingUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (OptionConfiguration)optionConfiguration.build();
    }

    public static OptionConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OptionConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

