/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.ModifyDBClusterRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyDBClusterRequestMarshaller
implements Marshaller<Request<ModifyDBClusterRequest>, ModifyDBClusterRequest> {
    public Request<ModifyDBClusterRequest> marshall(ModifyDBClusterRequest modifyDBClusterRequest) {
        SdkInternalList vpcSecurityGroupIdsList;
        if (modifyDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBClusterRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)modifyDBClusterRequest.dbClusterIdentifier()));
        }
        if (modifyDBClusterRequest.newDBClusterIdentifier() != null) {
            request.addParameter("NewDBClusterIdentifier", StringUtils.fromString((String)modifyDBClusterRequest.newDBClusterIdentifier()));
        }
        if (modifyDBClusterRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.applyImmediately()));
        }
        if (modifyDBClusterRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)modifyDBClusterRequest.backupRetentionPeriod()));
        }
        if (modifyDBClusterRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)modifyDBClusterRequest.dbClusterParameterGroupName()));
        }
        if (!(vpcSecurityGroupIdsList = (SdkInternalList)modifyDBClusterRequest.vpcSecurityGroupIds()).isEmpty() || !vpcSecurityGroupIdsList.isAutoConstruct()) {
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDBClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)modifyDBClusterRequest.port()));
        }
        if (modifyDBClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)modifyDBClusterRequest.masterUserPassword()));
        }
        if (modifyDBClusterRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)modifyDBClusterRequest.optionGroupName()));
        }
        if (modifyDBClusterRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)modifyDBClusterRequest.preferredBackupWindow()));
        }
        if (modifyDBClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyDBClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyDBClusterRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)modifyDBClusterRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

