/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeDBClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDBClusterSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeDBClusterSnapshotsRequest>, DescribeDBClusterSnapshotsRequest> {
    public Request<DescribeDBClusterSnapshotsRequest> marshall(DescribeDBClusterSnapshotsRequest describeDBClusterSnapshotsRequest) {
        SdkInternalList filtersList;
        if (describeDBClusterSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterSnapshotsRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBClusterSnapshots");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBClusterSnapshotsRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.dbClusterIdentifier()));
        }
        if (describeDBClusterSnapshotsRequest.dbClusterSnapshotIdentifier() != null) {
            request.addParameter("DBClusterSnapshotIdentifier", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.dbClusterSnapshotIdentifier()));
        }
        if (describeDBClusterSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.snapshotType()));
        }
        if (!(filtersList = (SdkInternalList)describeDBClusterSnapshotsRequest.filters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.values()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBClusterSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterSnapshotsRequest.maxRecords()));
        }
        if (describeDBClusterSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterSnapshotsRequest.marker()));
        }
        if (describeDBClusterSnapshotsRequest.includeShared() != null) {
            request.addParameter("IncludeShared", StringUtils.fromBoolean((Boolean)describeDBClusterSnapshotsRequest.includeShared()));
        }
        if (describeDBClusterSnapshotsRequest.includePublic() != null) {
            request.addParameter("IncludePublic", StringUtils.fromBoolean((Boolean)describeDBClusterSnapshotsRequest.includePublic()));
        }
        return request;
    }
}

