/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo;
import software.amazon.awssdk.services.rds.model.DBParameterGroupStatus;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.DomainMembership;
import software.amazon.awssdk.services.rds.model.OptionGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.transform.DBInstanceStatusInfoUnmarshaller;
import software.amazon.awssdk.services.rds.transform.DBParameterGroupStatusUnmarshaller;
import software.amazon.awssdk.services.rds.transform.DBSecurityGroupMembershipUnmarshaller;
import software.amazon.awssdk.services.rds.transform.DBSubnetGroupUnmarshaller;
import software.amazon.awssdk.services.rds.transform.DomainMembershipUnmarshaller;
import software.amazon.awssdk.services.rds.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.rds.transform.OptionGroupMembershipUnmarshaller;
import software.amazon.awssdk.services.rds.transform.PendingModifiedValuesUnmarshaller;
import software.amazon.awssdk.services.rds.transform.VpcSecurityGroupMembershipUnmarshaller;

public class DBInstanceUnmarshaller
implements Unmarshaller<DBInstance, StaxUnmarshallerContext> {
    private static DBInstanceUnmarshaller INSTANCE;

    public DBInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBInstance.Builder dbInstance = DBInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBInstanceIdentifier", targetDepth)) {
                    dbInstance.dbInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceClass", targetDepth)) {
                    dbInstance.dbInstanceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Engine", targetDepth)) {
                    dbInstance.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceStatus", targetDepth)) {
                    dbInstance.dbInstanceStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MasterUsername", targetDepth)) {
                    dbInstance.masterUsername(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBName", targetDepth)) {
                    dbInstance.dbName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    dbInstance.endpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllocatedStorage", targetDepth)) {
                    dbInstance.allocatedStorage(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceCreateTime", targetDepth)) {
                    dbInstance.instanceCreateTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredBackupWindow", targetDepth)) {
                    dbInstance.preferredBackupWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BackupRetentionPeriod", targetDepth)) {
                    dbInstance.backupRetentionPeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSecurityGroups", targetDepth)) {
                    dbInstance.dbSecurityGroups(new ArrayList<DBSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("DBSecurityGroups/DBSecurityGroup", targetDepth)) {
                    dbInstance.dbSecurityGroups(DBSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups", targetDepth)) {
                    dbInstance.vpcSecurityGroups(new ArrayList<VpcSecurityGroupMembership>());
                    continue;
                }
                if (context.testExpression("VpcSecurityGroups/VpcSecurityGroupMembership", targetDepth)) {
                    dbInstance.vpcSecurityGroups(VpcSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBParameterGroups", targetDepth)) {
                    dbInstance.dbParameterGroups(new ArrayList<DBParameterGroupStatus>());
                    continue;
                }
                if (context.testExpression("DBParameterGroups/DBParameterGroup", targetDepth)) {
                    dbInstance.dbParameterGroups(DBParameterGroupStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    dbInstance.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBSubnetGroup", targetDepth)) {
                    dbInstance.dbSubnetGroup(DBSubnetGroupUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    dbInstance.preferredMaintenanceWindow(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PendingModifiedValues", targetDepth)) {
                    dbInstance.pendingModifiedValues(PendingModifiedValuesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LatestRestorableTime", targetDepth)) {
                    dbInstance.latestRestorableTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MultiAZ", targetDepth)) {
                    dbInstance.multiAZ(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EngineVersion", targetDepth)) {
                    dbInstance.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoMinorVersionUpgrade", targetDepth)) {
                    dbInstance.autoMinorVersionUpgrade(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReadReplicaSourceDBInstanceIdentifier", targetDepth)) {
                    dbInstance.readReplicaSourceDBInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReadReplicaDBInstanceIdentifiers", targetDepth)) {
                    dbInstance.readReplicaDBInstanceIdentifiers(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ReadReplicaDBInstanceIdentifiers/ReadReplicaDBInstanceIdentifier", targetDepth)) {
                    dbInstance.readReplicaDBInstanceIdentifiers(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReadReplicaDBClusterIdentifiers", targetDepth)) {
                    dbInstance.readReplicaDBClusterIdentifiers(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ReadReplicaDBClusterIdentifiers/ReadReplicaDBClusterIdentifier", targetDepth)) {
                    dbInstance.readReplicaDBClusterIdentifiers(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LicenseModel", targetDepth)) {
                    dbInstance.licenseModel(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Iops", targetDepth)) {
                    dbInstance.iops(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OptionGroupMemberships", targetDepth)) {
                    dbInstance.optionGroupMemberships(new ArrayList<OptionGroupMembership>());
                    continue;
                }
                if (context.testExpression("OptionGroupMemberships/OptionGroupMembership", targetDepth)) {
                    dbInstance.optionGroupMemberships(OptionGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CharacterSetName", targetDepth)) {
                    dbInstance.characterSetName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecondaryAvailabilityZone", targetDepth)) {
                    dbInstance.secondaryAvailabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PubliclyAccessible", targetDepth)) {
                    dbInstance.publiclyAccessible(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusInfos", targetDepth)) {
                    dbInstance.statusInfos(new ArrayList<DBInstanceStatusInfo>());
                    continue;
                }
                if (context.testExpression("StatusInfos/DBInstanceStatusInfo", targetDepth)) {
                    dbInstance.statusInfos(DBInstanceStatusInfoUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageType", targetDepth)) {
                    dbInstance.storageType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TdeCredentialArn", targetDepth)) {
                    dbInstance.tdeCredentialArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DbInstancePort", targetDepth)) {
                    dbInstance.dbInstancePort(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterIdentifier", targetDepth)) {
                    dbInstance.dbClusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageEncrypted", targetDepth)) {
                    dbInstance.storageEncrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    dbInstance.kmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DbiResourceId", targetDepth)) {
                    dbInstance.dbiResourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CACertificateIdentifier", targetDepth)) {
                    dbInstance.caCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainMemberships", targetDepth)) {
                    dbInstance.domainMemberships(new ArrayList<DomainMembership>());
                    continue;
                }
                if (context.testExpression("DomainMemberships/DomainMembership", targetDepth)) {
                    dbInstance.domainMemberships(DomainMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CopyTagsToSnapshot", targetDepth)) {
                    dbInstance.copyTagsToSnapshot(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MonitoringInterval", targetDepth)) {
                    dbInstance.monitoringInterval(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnhancedMonitoringResourceArn", targetDepth)) {
                    dbInstance.enhancedMonitoringResourceArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MonitoringRoleArn", targetDepth)) {
                    dbInstance.monitoringRoleArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PromotionTier", targetDepth)) {
                    dbInstance.promotionTier(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBInstanceArn", targetDepth)) {
                    dbInstance.dbInstanceArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timezone", targetDepth)) {
                    dbInstance.timezone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IAMDatabaseAuthenticationEnabled", targetDepth)) continue;
                dbInstance.iamDatabaseAuthenticationEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBInstance)dbInstance.build();
    }

    public static DBInstanceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBInstanceUnmarshaller();
        }
        return INSTANCE;
    }
}

