/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute;

public class DBClusterSnapshotAttributeUnmarshaller
implements Unmarshaller<DBClusterSnapshotAttribute, StaxUnmarshallerContext> {
    private static DBClusterSnapshotAttributeUnmarshaller INSTANCE;

    public DBClusterSnapshotAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBClusterSnapshotAttribute.Builder dbClusterSnapshotAttribute = DBClusterSnapshotAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AttributeName", targetDepth)) {
                    dbClusterSnapshotAttribute.attributeName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AttributeValues", targetDepth)) {
                    dbClusterSnapshotAttribute.attributeValues(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("AttributeValues/AttributeValue", targetDepth)) continue;
                dbClusterSnapshotAttribute.attributeValues(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBClusterSnapshotAttribute)dbClusterSnapshotAttribute.build();
    }

    public static DBClusterSnapshotAttributeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBClusterSnapshotAttributeUnmarshaller();
        }
        return INSTANCE;
    }
}

