/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreDBClusterToPointInTimeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RestoreDBClusterToPointInTimeRequest> {
    private final String dbClusterIdentifier;
    private final String restoreType;
    private final String sourceDBClusterIdentifier;
    private final Date restoreToTime;
    private final Boolean useLatestRestorableTime;
    private final Integer port;
    private final String dbSubnetGroupName;
    private final String optionGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enableIAMDatabaseAuthentication;

    private RestoreDBClusterToPointInTimeRequest(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.restoreType = builder.restoreType;
        this.sourceDBClusterIdentifier = builder.sourceDBClusterIdentifier;
        this.restoreToTime = builder.restoreToTime;
        this.useLatestRestorableTime = builder.useLatestRestorableTime;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.optionGroupName = builder.optionGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String restoreType() {
        return this.restoreType;
    }

    public String sourceDBClusterIdentifier() {
        return this.sourceDBClusterIdentifier;
    }

    public Date restoreToTime() {
        return this.restoreToTime;
    }

    public Boolean useLatestRestorableTime() {
        return this.useLatestRestorableTime;
    }

    public Integer port() {
        return this.port;
    }

    public String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.restoreType() == null ? 0 : this.restoreType().hashCode());
        hashCode = 31 * hashCode + (this.sourceDBClusterIdentifier() == null ? 0 : this.sourceDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.restoreToTime() == null ? 0 : this.restoreToTime().hashCode());
        hashCode = 31 * hashCode + (this.useLatestRestorableTime() == null ? 0 : this.useLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroupName() == null ? 0 : this.dbSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupIds() == null ? 0 : this.vpcSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.enableIAMDatabaseAuthentication() == null ? 0 : this.enableIAMDatabaseAuthentication().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDBClusterToPointInTimeRequest)) {
            return false;
        }
        RestoreDBClusterToPointInTimeRequest other = (RestoreDBClusterToPointInTimeRequest)((Object)obj);
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.restoreType() == null ^ this.restoreType() == null) {
            return false;
        }
        if (other.restoreType() != null && !other.restoreType().equals(this.restoreType())) {
            return false;
        }
        if (other.sourceDBClusterIdentifier() == null ^ this.sourceDBClusterIdentifier() == null) {
            return false;
        }
        if (other.sourceDBClusterIdentifier() != null && !other.sourceDBClusterIdentifier().equals(this.sourceDBClusterIdentifier())) {
            return false;
        }
        if (other.restoreToTime() == null ^ this.restoreToTime() == null) {
            return false;
        }
        if (other.restoreToTime() != null && !other.restoreToTime().equals(this.restoreToTime())) {
            return false;
        }
        if (other.useLatestRestorableTime() == null ^ this.useLatestRestorableTime() == null) {
            return false;
        }
        if (other.useLatestRestorableTime() != null && !other.useLatestRestorableTime().equals(this.useLatestRestorableTime())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.dbSubnetGroupName() == null ^ this.dbSubnetGroupName() == null) {
            return false;
        }
        if (other.dbSubnetGroupName() != null && !other.dbSubnetGroupName().equals(this.dbSubnetGroupName())) {
            return false;
        }
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.vpcSecurityGroupIds() == null ^ this.vpcSecurityGroupIds() == null) {
            return false;
        }
        if (other.vpcSecurityGroupIds() != null && !other.vpcSecurityGroupIds().equals(this.vpcSecurityGroupIds())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.enableIAMDatabaseAuthentication() == null ^ this.enableIAMDatabaseAuthentication() == null) {
            return false;
        }
        return other.enableIAMDatabaseAuthentication() == null || other.enableIAMDatabaseAuthentication().equals(this.enableIAMDatabaseAuthentication());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.restoreType() != null) {
            sb.append("RestoreType: ").append(this.restoreType()).append(",");
        }
        if (this.sourceDBClusterIdentifier() != null) {
            sb.append("SourceDBClusterIdentifier: ").append(this.sourceDBClusterIdentifier()).append(",");
        }
        if (this.restoreToTime() != null) {
            sb.append("RestoreToTime: ").append(this.restoreToTime()).append(",");
        }
        if (this.useLatestRestorableTime() != null) {
            sb.append("UseLatestRestorableTime: ").append(this.useLatestRestorableTime()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.dbSubnetGroupName() != null) {
            sb.append("DBSubnetGroupName: ").append(this.dbSubnetGroupName()).append(",");
        }
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.vpcSecurityGroupIds() != null) {
            sb.append("VpcSecurityGroupIds: ").append(this.vpcSecurityGroupIds()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.enableIAMDatabaseAuthentication() != null) {
            sb.append("EnableIAMDatabaseAuthentication: ").append(this.enableIAMDatabaseAuthentication()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String restoreType;
        private String sourceDBClusterIdentifier;
        private Date restoreToTime;
        private Boolean useLatestRestorableTime;
        private Integer port;
        private String dbSubnetGroupName;
        private String optionGroupName;
        private List<String> vpcSecurityGroupIds = new SdkInternalList();
        private List<Tag> tags = new SdkInternalList();
        private String kmsKeyId;
        private Boolean enableIAMDatabaseAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDBClusterToPointInTimeRequest model) {
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setRestoreType(model.restoreType);
            this.setSourceDBClusterIdentifier(model.sourceDBClusterIdentifier);
            this.setRestoreToTime(model.restoreToTime);
            this.setUseLatestRestorableTime(model.useLatestRestorableTime);
            this.setPort(model.port);
            this.setDBSubnetGroupName(model.dbSubnetGroupName);
            this.setOptionGroupName(model.optionGroupName);
            this.setVpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.setTags(model.tags);
            this.setKmsKeyId(model.kmsKeyId);
            this.setEnableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getRestoreType() {
            return this.restoreType;
        }

        @Override
        public final Builder restoreType(String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        public final void setRestoreType(String restoreType) {
            this.restoreType = restoreType;
        }

        public final String getSourceDBClusterIdentifier() {
            return this.sourceDBClusterIdentifier;
        }

        @Override
        public final Builder sourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
            return this;
        }

        public final void setSourceDBClusterIdentifier(String sourceDBClusterIdentifier) {
            this.sourceDBClusterIdentifier = sourceDBClusterIdentifier;
        }

        public final Date getRestoreToTime() {
            return this.restoreToTime;
        }

        @Override
        public final Builder restoreToTime(Date restoreToTime) {
            this.restoreToTime = StandardMemberCopier.copy((Date)restoreToTime);
            return this;
        }

        public final void setRestoreToTime(Date restoreToTime) {
            this.restoreToTime = StandardMemberCopier.copy((Date)restoreToTime);
        }

        public final Boolean getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final Builder useLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        public final void setUseLatestRestorableTime(Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDBSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final void setDBSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            if (this.vpcSecurityGroupIds == null) {
                this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds.length);
            }
            for (String e : vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds.add(e);
            }
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @SafeVarargs
        public final void setVpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            if (this.vpcSecurityGroupIds == null) {
                this.vpcSecurityGroupIds = new SdkInternalList(vpcSecurityGroupIds.length);
            }
            for (String e : vpcSecurityGroupIds) {
                this.vpcSecurityGroupIds.add(e);
            }
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        public RestoreDBClusterToPointInTimeRequest build() {
            return new RestoreDBClusterToPointInTimeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreDBClusterToPointInTimeRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder restoreType(String var1);

        public Builder sourceDBClusterIdentifier(String var1);

        public Builder restoreToTime(Date var1);

        public Builder useLatestRestorableTime(Boolean var1);

        public Builder port(Integer var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder optionGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);
    }
}

