/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceActionsCopier;
import software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePendingMaintenanceActionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
    private final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions;
    private final String marker;

    private DescribePendingMaintenanceActionsResponse(BuilderImpl builder) {
        this.pendingMaintenanceActions = builder.pendingMaintenanceActions;
        this.marker = builder.marker;
    }

    public List<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        return this.pendingMaintenanceActions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pendingMaintenanceActions() == null ? 0 : this.pendingMaintenanceActions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsResponse)) {
            return false;
        }
        DescribePendingMaintenanceActionsResponse other = (DescribePendingMaintenanceActionsResponse)((Object)obj);
        if (other.pendingMaintenanceActions() == null ^ this.pendingMaintenanceActions() == null) {
            return false;
        }
        if (other.pendingMaintenanceActions() != null && !other.pendingMaintenanceActions().equals(this.pendingMaintenanceActions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pendingMaintenanceActions() != null) {
            sb.append("PendingMaintenanceActions: ").append(this.pendingMaintenanceActions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ResourcePendingMaintenanceActions> pendingMaintenanceActions = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsResponse model) {
            this.setPendingMaintenanceActions(model.pendingMaintenanceActions);
            this.setMarker(model.marker);
        }

        public final Collection<ResourcePendingMaintenanceActions> getPendingMaintenanceActions() {
            return this.pendingMaintenanceActions;
        }

        @Override
        public final Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copy(pendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... pendingMaintenanceActions) {
            if (this.pendingMaintenanceActions == null) {
                this.pendingMaintenanceActions = new SdkInternalList(pendingMaintenanceActions.length);
            }
            for (ResourcePendingMaintenanceActions e : pendingMaintenanceActions) {
                this.pendingMaintenanceActions.add(e);
            }
            return this;
        }

        public final void setPendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copy(pendingMaintenanceActions);
        }

        @SafeVarargs
        public final void setPendingMaintenanceActions(ResourcePendingMaintenanceActions ... pendingMaintenanceActions) {
            if (this.pendingMaintenanceActions == null) {
                this.pendingMaintenanceActions = new SdkInternalList(pendingMaintenanceActions.length);
            }
            for (ResourcePendingMaintenanceActions e : pendingMaintenanceActions) {
                this.pendingMaintenanceActions.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribePendingMaintenanceActionsResponse build() {
            return new DescribePendingMaintenanceActionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
        public Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> var1);

        public Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... var1);

        public Builder marker(String var1);
    }
}

