/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.rds.model.AttributeValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSnapshotAttribute
implements ToCopyableBuilder<Builder, DBSnapshotAttribute> {
    private final String attributeName;
    private final List<String> attributeValues;

    private DBSnapshotAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<String> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.attributeValues() == null ? 0 : this.attributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotAttribute)) {
            return false;
        }
        DBSnapshotAttribute other = (DBSnapshotAttribute)obj;
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValues() == null ^ this.attributeValues() == null) {
            return false;
        }
        return other.attributeValues() == null || other.attributeValues().equals(this.attributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeValues() != null) {
            sb.append("AttributeValues: ").append(this.attributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<String> attributeValues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotAttribute model) {
            this.setAttributeName(model.attributeName);
            this.setAttributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<String> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(String ... attributeValues) {
            if (this.attributeValues == null) {
                this.attributeValues = new SdkInternalList(attributeValues.length);
            }
            for (String e : attributeValues) {
                this.attributeValues.add(e);
            }
            return this;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
        }

        @SafeVarargs
        public final void setAttributeValues(String ... attributeValues) {
            if (this.attributeValues == null) {
                this.attributeValues = new SdkInternalList(attributeValues.length);
            }
            for (String e : attributeValues) {
                this.attributeValues.add(e);
            }
        }

        public DBSnapshotAttribute build() {
            return new DBSnapshotAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSnapshotAttribute> {
        public Builder attributeName(String var1);

        public Builder attributeValues(Collection<String> var1);

        public Builder attributeValues(String ... var1);
    }
}

