/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rbin.model.ExcludeResourceTagsCopier;
import software.amazon.awssdk.services.rbin.model.LockConfiguration;
import software.amazon.awssdk.services.rbin.model.LockState;
import software.amazon.awssdk.services.rbin.model.RbinResponse;
import software.amazon.awssdk.services.rbin.model.ResourceTag;
import software.amazon.awssdk.services.rbin.model.ResourceTagsCopier;
import software.amazon.awssdk.services.rbin.model.ResourceType;
import software.amazon.awssdk.services.rbin.model.RetentionPeriod;
import software.amazon.awssdk.services.rbin.model.RuleStatus;
import software.amazon.awssdk.services.rbin.model.Tag;
import software.amazon.awssdk.services.rbin.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRuleResponse
extends RbinResponse
implements ToCopyableBuilder<Builder, CreateRuleResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(CreateRuleResponse.getter(CreateRuleResponse::identifier)).setter(CreateRuleResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionPeriod").getter(CreateRuleResponse.getter(CreateRuleResponse::retentionPeriod)).setter(CreateRuleResponse.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateRuleResponse.getter(CreateRuleResponse::description)).setter(CreateRuleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRuleResponse.getter(CreateRuleResponse::tags)).setter(CreateRuleResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CreateRuleResponse.getter(CreateRuleResponse::resourceTypeAsString)).setter(CreateRuleResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateRuleResponse.getter(CreateRuleResponse::resourceTags)).setter(CreateRuleResponse.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateRuleResponse.getter(CreateRuleResponse::statusAsString)).setter(CreateRuleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<LockConfiguration> LOCK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockConfiguration").getter(CreateRuleResponse.getter(CreateRuleResponse::lockConfiguration)).setter(CreateRuleResponse.setter(Builder::lockConfiguration)).constructor(LockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockConfiguration").build()}).build();
    private static final SdkField<String> LOCK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LockState").getter(CreateRuleResponse.getter(CreateRuleResponse::lockStateAsString)).setter(CreateRuleResponse.setter(Builder::lockState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockState").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(CreateRuleResponse.getter(CreateRuleResponse::ruleArn)).setter(CreateRuleResponse.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<List<ResourceTag>> EXCLUDE_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeResourceTags").getter(CreateRuleResponse.getter(CreateRuleResponse::excludeResourceTags)).setter(CreateRuleResponse.setter(Builder::excludeResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, RETENTION_PERIOD_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, STATUS_FIELD, LOCK_CONFIGURATION_FIELD, LOCK_STATE_FIELD, RULE_ARN_FIELD, EXCLUDE_RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRuleResponse.memberNameToFieldInitializer();
    private final String identifier;
    private final RetentionPeriod retentionPeriod;
    private final String description;
    private final List<Tag> tags;
    private final String resourceType;
    private final List<ResourceTag> resourceTags;
    private final String status;
    private final LockConfiguration lockConfiguration;
    private final String lockState;
    private final String ruleArn;
    private final List<ResourceTag> excludeResourceTags;

    private CreateRuleResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.retentionPeriod = builder.retentionPeriod;
        this.description = builder.description;
        this.tags = builder.tags;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.status = builder.status;
        this.lockConfiguration = builder.lockConfiguration;
        this.lockState = builder.lockState;
        this.ruleArn = builder.ruleArn;
        this.excludeResourceTags = builder.excludeResourceTags;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final RuleStatus status() {
        return RuleStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final LockConfiguration lockConfiguration() {
        return this.lockConfiguration;
    }

    public final LockState lockState() {
        return LockState.fromValue(this.lockState);
    }

    public final String lockStateAsString() {
        return this.lockState;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final boolean hasExcludeResourceTags() {
        return this.excludeResourceTags != null && !(this.excludeResourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> excludeResourceTags() {
        return this.excludeResourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeResourceTags() ? this.excludeResourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleResponse)) {
            return false;
        }
        CreateRuleResponse other = (CreateRuleResponse)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lockConfiguration(), other.lockConfiguration()) && Objects.equals(this.lockStateAsString(), other.lockStateAsString()) && Objects.equals(this.ruleArn(), other.ruleArn()) && this.hasExcludeResourceTags() == other.hasExcludeResourceTags() && Objects.equals(this.excludeResourceTags(), other.excludeResourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRuleResponse").add("Identifier", (Object)this.identifier()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("Status", (Object)this.statusAsString()).add("LockConfiguration", (Object)this.lockConfiguration()).add("LockState", (Object)this.lockStateAsString()).add("RuleArn", (Object)this.ruleArn()).add("ExcludeResourceTags", this.hasExcludeResourceTags() ? this.excludeResourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LockConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lockConfiguration()));
            }
            case "LockState": {
                return Optional.ofNullable(clazz.cast(this.lockStateAsString()));
            }
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "ExcludeResourceTags": {
                return Optional.ofNullable(clazz.cast(this.excludeResourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceTags", RESOURCE_TAGS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LockConfiguration", LOCK_CONFIGURATION_FIELD);
        map.put("LockState", LOCK_STATE_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("ExcludeResourceTags", EXCLUDE_RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleResponse, T> g) {
        return obj -> g.apply((CreateRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RbinResponse.BuilderImpl
    implements Builder {
        private String identifier;
        private RetentionPeriod retentionPeriod;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private LockConfiguration lockConfiguration;
        private String lockState;
        private String ruleArn;
        private List<ResourceTag> excludeResourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleResponse model) {
            super(model);
            this.identifier(model.identifier);
            this.retentionPeriod(model.retentionPeriod);
            this.description(model.description);
            this.tags(model.tags);
            this.resourceType(model.resourceType);
            this.resourceTags(model.resourceTags);
            this.status(model.status);
            this.lockConfiguration(model.lockConfiguration);
            this.lockState(model.lockState);
            this.ruleArn(model.ruleArn);
            this.excludeResourceTags(model.excludeResourceTags);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final LockConfiguration.Builder getLockConfiguration() {
            return this.lockConfiguration != null ? this.lockConfiguration.toBuilder() : null;
        }

        public final void setLockConfiguration(LockConfiguration.BuilderImpl lockConfiguration) {
            this.lockConfiguration = lockConfiguration != null ? lockConfiguration.build() : null;
        }

        @Override
        public final Builder lockConfiguration(LockConfiguration lockConfiguration) {
            this.lockConfiguration = lockConfiguration;
            return this;
        }

        public final String getLockState() {
            return this.lockState;
        }

        public final void setLockState(String lockState) {
            this.lockState = lockState;
        }

        @Override
        public final Builder lockState(String lockState) {
            this.lockState = lockState;
            return this;
        }

        @Override
        public final Builder lockState(LockState lockState) {
            this.lockState(lockState == null ? null : lockState.toString());
            return this;
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final List<ResourceTag.Builder> getExcludeResourceTags() {
            List<ResourceTag.Builder> result = ExcludeResourceTagsCopier.copyToBuilder(this.excludeResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeResourceTags(Collection<ResourceTag.BuilderImpl> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copyFromBuilder(excludeResourceTags);
        }

        @Override
        public final Builder excludeResourceTags(Collection<ResourceTag> excludeResourceTags) {
            this.excludeResourceTags = ExcludeResourceTagsCopier.copy(excludeResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(ResourceTag ... excludeResourceTags) {
            this.excludeResourceTags(Arrays.asList(excludeResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeResourceTags(Consumer<ResourceTag.Builder> ... excludeResourceTags) {
            this.excludeResourceTags(Stream.of(excludeResourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateRuleResponse build() {
            return new CreateRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RbinResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRuleResponse> {
        public Builder identifier(String var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(RuleStatus var1);

        public Builder lockConfiguration(LockConfiguration var1);

        default public Builder lockConfiguration(Consumer<LockConfiguration.Builder> lockConfiguration) {
            return this.lockConfiguration((LockConfiguration)((LockConfiguration.Builder)LockConfiguration.builder().applyMutation(lockConfiguration)).build());
        }

        public Builder lockState(String var1);

        public Builder lockState(LockState var1);

        public Builder ruleArn(String var1);

        public Builder excludeResourceTags(Collection<ResourceTag> var1);

        public Builder excludeResourceTags(ResourceTag ... var1);

        public Builder excludeResourceTags(Consumer<ResourceTag.Builder> ... var1);
    }
}

