/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rbin.DefaultRbinBaseClientBuilder;
import software.amazon.awssdk.services.rbin.DefaultRbinClient;
import software.amazon.awssdk.services.rbin.RbinClient;
import software.amazon.awssdk.services.rbin.RbinClientBuilder;
import software.amazon.awssdk.services.rbin.RbinServiceClientConfiguration;
import software.amazon.awssdk.services.rbin.endpoints.RbinEndpointProvider;

@SdkInternalApi
final class DefaultRbinClientBuilder
extends DefaultRbinBaseClientBuilder<RbinClientBuilder, RbinClient>
implements RbinClientBuilder {
    DefaultRbinClientBuilder() {
    }

    @Override
    public DefaultRbinClientBuilder endpointProvider(RbinEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RbinClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRbinClientBuilder.validateClientOptions(clientConfiguration);
        RbinServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRbinClient client = new DefaultRbinClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RbinServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RbinServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

