/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rbin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rbin.model.RbinRequest;
import software.amazon.awssdk.services.rbin.model.ResourceTag;
import software.amazon.awssdk.services.rbin.model.ResourceTagsCopier;
import software.amazon.awssdk.services.rbin.model.ResourceType;
import software.amazon.awssdk.services.rbin.model.RetentionPeriod;
import software.amazon.awssdk.services.rbin.model.Tag;
import software.amazon.awssdk.services.rbin.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRuleRequest
extends RbinRequest
implements ToCopyableBuilder<Builder, CreateRuleRequest> {
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetentionPeriod").getter(CreateRuleRequest.getter(CreateRuleRequest::retentionPeriod)).setter(CreateRuleRequest.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateRuleRequest.getter(CreateRuleRequest::description)).setter(CreateRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRuleRequest.getter(CreateRuleRequest::tags)).setter(CreateRuleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(CreateRuleRequest.getter(CreateRuleRequest::resourceTypeAsString)).setter(CreateRuleRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(CreateRuleRequest.getter(CreateRuleRequest::resourceTags)).setter(CreateRuleRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_PERIOD_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD));
    private final RetentionPeriod retentionPeriod;
    private final String description;
    private final List<Tag> tags;
    private final String resourceType;
    private final List<ResourceTag> resourceTags;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.retentionPeriod = builder.retentionPeriod;
        this.description = builder.description;
        this.tags = builder.tags;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest)((Object)obj);
        return Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRuleRequest").add("RetentionPeriod", (Object)this.retentionPeriod()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RbinRequest.BuilderImpl
    implements Builder {
        private RetentionPeriod retentionPeriod;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            this.retentionPeriod(model.retentionPeriod);
            this.description(model.description);
            this.tags(model.tags);
            this.resourceType(model.resourceType);
            this.resourceTags(model.resourceTags);
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagsCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RbinRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRuleRequest> {
        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

