/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;

public class ListPendingInvitationResourcesIterable
implements SdkIterable<ListPendingInvitationResourcesResponse> {
    private final RamClient client;
    private final ListPendingInvitationResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPendingInvitationResourcesIterable(RamClient client, ListPendingInvitationResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPendingInvitationResourcesResponseFetcher();
    }

    public Iterator<ListPendingInvitationResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPendingInvitationResourcesResponseFetcher
    implements SyncPageFetcher<ListPendingInvitationResourcesResponse> {
        private ListPendingInvitationResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListPendingInvitationResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPendingInvitationResourcesResponse nextPage(ListPendingInvitationResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListPendingInvitationResourcesIterable.this.client.listPendingInvitationResources(ListPendingInvitationResourcesIterable.this.firstRequest);
            }
            return ListPendingInvitationResourcesIterable.this.client.listPendingInvitationResources((ListPendingInvitationResourcesRequest)((Object)ListPendingInvitationResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

