/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.PrincipalArnOrIdListCopier;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.ResourceArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateResourceShareRequest
extends RamRequest
implements ToCopyableBuilder<Builder, AssociateResourceShareRequest> {
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceShareArn").getter(AssociateResourceShareRequest.getter(AssociateResourceShareRequest::resourceShareArn)).setter(AssociateResourceShareRequest.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceShareArn").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceArns").getter(AssociateResourceShareRequest.getter(AssociateResourceShareRequest::resourceArns)).setter(AssociateResourceShareRequest.setter(Builder::resourceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("principals").getter(AssociateResourceShareRequest.getter(AssociateResourceShareRequest::principals)).setter(AssociateResourceShareRequest.setter(Builder::principals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AssociateResourceShareRequest.getter(AssociateResourceShareRequest::clientToken)).setter(AssociateResourceShareRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SHARE_ARN_FIELD, RESOURCE_ARNS_FIELD, PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD));
    private final String resourceShareArn;
    private final List<String> resourceArns;
    private final List<String> principals;
    private final String clientToken;

    private AssociateResourceShareRequest(BuilderImpl builder) {
        super(builder);
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceArns = builder.resourceArns;
        this.principals = builder.principals;
        this.clientToken = builder.clientToken;
    }

    public String resourceShareArn() {
        return this.resourceShareArn;
    }

    public boolean hasResourceArns() {
        return this.resourceArns != null && !(this.resourceArns instanceof SdkAutoConstructList);
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public boolean hasPrincipals() {
        return this.principals != null && !(this.principals instanceof SdkAutoConstructList);
    }

    public List<String> principals() {
        return this.principals;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArns() ? this.resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipals() ? this.principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResourceShareRequest)) {
            return false;
        }
        AssociateResourceShareRequest other = (AssociateResourceShareRequest)((Object)obj);
        return Objects.equals(this.resourceShareArn(), other.resourceShareArn()) && this.hasResourceArns() == other.hasResourceArns() && Objects.equals(this.resourceArns(), other.resourceArns()) && this.hasPrincipals() == other.hasPrincipals() && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"AssociateResourceShareRequest").add("ResourceShareArn", (Object)this.resourceShareArn()).add("ResourceArns", this.hasResourceArns() ? this.resourceArns() : null).add("Principals", this.hasPrincipals() ? this.principals() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
            case "resourceArns": {
                return Optional.ofNullable(clazz.cast(this.resourceArns()));
            }
            case "principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateResourceShareRequest, T> g) {
        return obj -> g.apply((AssociateResourceShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String resourceShareArn;
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> principals = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResourceShareRequest model) {
            super(model);
            this.resourceShareArn(model.resourceShareArn);
            this.resourceArns(model.resourceArns);
            this.principals(model.principals);
            this.clientToken(model.clientToken);
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        public final Collection<String> getResourceArns() {
            if (this.resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnListCopier.copy(resourceArns);
        }

        public final Collection<String> getPrincipals() {
            if (this.principals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalArnOrIdListCopier.copy(principals);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResourceShareRequest build() {
            return new AssociateResourceShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateResourceShareRequest> {
        public Builder resourceShareArn(String var1);

        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

