/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ram.RamClient;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.AcceptResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.AssociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.CreateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.CreateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DeleteResourceShareResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceSharePermissionResponse;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.DisassociateResourceShareResponse;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationRequest;
import software.amazon.awssdk.services.ram.model.EnableSharingWithAwsOrganizationResponse;
import software.amazon.awssdk.services.ram.model.GetPermissionRequest;
import software.amazon.awssdk.services.ram.model.GetPermissionResponse;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ram.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareAssociationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsRequest;
import software.amazon.awssdk.services.ram.model.GetResourceShareInvitationsResponse;
import software.amazon.awssdk.services.ram.model.GetResourceSharesRequest;
import software.amazon.awssdk.services.ram.model.GetResourceSharesResponse;
import software.amazon.awssdk.services.ram.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ram.model.InvalidClientTokenException;
import software.amazon.awssdk.services.ram.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.ram.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ram.model.InvalidParameterException;
import software.amazon.awssdk.services.ram.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ram.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListPendingInvitationResourcesResponse;
import software.amazon.awssdk.services.ram.model.ListPermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListPermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListPrincipalsRequest;
import software.amazon.awssdk.services.ram.model.ListPrincipalsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsRequest;
import software.amazon.awssdk.services.ram.model.ListResourceSharePermissionsResponse;
import software.amazon.awssdk.services.ram.model.ListResourceTypesRequest;
import software.amazon.awssdk.services.ram.model.ListResourceTypesResponse;
import software.amazon.awssdk.services.ram.model.ListResourcesRequest;
import software.amazon.awssdk.services.ram.model.ListResourcesResponse;
import software.amazon.awssdk.services.ram.model.MalformedArnException;
import software.amazon.awssdk.services.ram.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.ram.model.OperationNotPermittedException;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyRequest;
import software.amazon.awssdk.services.ram.model.PromoteResourceShareCreatedFromPolicyResponse;
import software.amazon.awssdk.services.ram.model.RamException;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationRequest;
import software.amazon.awssdk.services.ram.model.RejectResourceShareInvitationResponse;
import software.amazon.awssdk.services.ram.model.ResourceArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyAcceptedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationAlreadyRejectedException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationArnNotFoundException;
import software.amazon.awssdk.services.ram.model.ResourceShareInvitationExpiredException;
import software.amazon.awssdk.services.ram.model.ResourceShareLimitExceededException;
import software.amazon.awssdk.services.ram.model.ServerInternalException;
import software.amazon.awssdk.services.ram.model.ServiceUnavailableException;
import software.amazon.awssdk.services.ram.model.TagLimitExceededException;
import software.amazon.awssdk.services.ram.model.TagPolicyViolationException;
import software.amazon.awssdk.services.ram.model.TagResourceRequest;
import software.amazon.awssdk.services.ram.model.TagResourceResponse;
import software.amazon.awssdk.services.ram.model.UnknownResourceException;
import software.amazon.awssdk.services.ram.model.UntagResourceRequest;
import software.amazon.awssdk.services.ram.model.UntagResourceResponse;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareRequest;
import software.amazon.awssdk.services.ram.model.UpdateResourceShareResponse;
import software.amazon.awssdk.services.ram.paginators.GetResourcePoliciesIterable;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareAssociationsIterable;
import software.amazon.awssdk.services.ram.paginators.GetResourceShareInvitationsIterable;
import software.amazon.awssdk.services.ram.paginators.GetResourceSharesIterable;
import software.amazon.awssdk.services.ram.paginators.ListPendingInvitationResourcesIterable;
import software.amazon.awssdk.services.ram.paginators.ListPrincipalsIterable;
import software.amazon.awssdk.services.ram.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.ram.transform.AcceptResourceShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.AssociateResourceSharePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.AssociateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.CreateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DeleteResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DisassociateResourceSharePermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.DisassociateResourceShareRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.EnableSharingWithAwsOrganizationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetPermissionRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceShareAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceShareInvitationsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.GetResourceSharesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPendingInvitationResourcesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPermissionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourceSharePermissionsRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.PromoteResourceShareCreatedFromPolicyRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.RejectResourceShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ram.transform.UpdateResourceShareRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRamClient
implements RamClient {
    private static final Logger log = Logger.loggerFor(DefaultRamClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRamClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ram";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptResourceShareInvitationResponse acceptResourceShareInvitation(AcceptResourceShareInvitationRequest acceptResourceShareInvitationRequest) throws MalformedArnException, OperationNotPermittedException, ResourceShareInvitationArnNotFoundException, ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptResourceShareInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, acceptResourceShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptResourceShareInvitation");
            AcceptResourceShareInvitationResponse acceptResourceShareInvitationResponse = (AcceptResourceShareInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptResourceShareInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptResourceShareInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptResourceShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptResourceShareInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$acceptResourceShareInvitation$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceShareResponse associateResourceShare(AssociateResourceShareRequest associateResourceShareRequest) throws IdempotentParameterMismatchException, UnknownResourceException, InvalidStateTransitionException, ResourceShareLimitExceededException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, associateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceShare");
            AssociateResourceShareResponse associateResourceShareResponse = (AssociateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$associateResourceShare$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateResourceSharePermissionResponse associateResourceSharePermission(AssociateResourceSharePermissionRequest associateResourceSharePermissionRequest) throws MalformedArnException, UnknownResourceException, InvalidParameterException, InvalidClientTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateResourceSharePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, associateResourceSharePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateResourceSharePermission");
            AssociateResourceSharePermissionResponse associateResourceSharePermissionResponse = (AssociateResourceSharePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateResourceSharePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateResourceSharePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateResourceSharePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateResourceSharePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$associateResourceSharePermission$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceShareResponse createResourceShare(CreateResourceShareRequest createResourceShareRequest) throws IdempotentParameterMismatchException, InvalidStateTransitionException, UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ResourceShareLimitExceededException, TagPolicyViolationException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, createResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResourceShare");
            CreateResourceShareResponse createResourceShareResponse = (CreateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResourceShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$createResourceShare$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceShareResponse deleteResourceShare(DeleteResourceShareRequest deleteResourceShareRequest) throws OperationNotPermittedException, IdempotentParameterMismatchException, InvalidStateTransitionException, UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, deleteResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourceShare");
            DeleteResourceShareResponse deleteResourceShareResponse = (DeleteResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourceShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$deleteResourceShare$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceShareResponse disassociateResourceShare(DisassociateResourceShareRequest disassociateResourceShareRequest) throws IdempotentParameterMismatchException, ResourceShareLimitExceededException, MalformedArnException, InvalidStateTransitionException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, disassociateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceShare");
            DisassociateResourceShareResponse disassociateResourceShareResponse = (DisassociateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$disassociateResourceShare$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateResourceSharePermissionResponse disassociateResourceSharePermission(DisassociateResourceSharePermissionRequest disassociateResourceSharePermissionRequest) throws MalformedArnException, UnknownResourceException, InvalidParameterException, InvalidClientTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateResourceSharePermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, disassociateResourceSharePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateResourceSharePermission");
            DisassociateResourceSharePermissionResponse disassociateResourceSharePermissionResponse = (DisassociateResourceSharePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateResourceSharePermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateResourceSharePermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateResourceSharePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateResourceSharePermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$disassociateResourceSharePermission$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganization(EnableSharingWithAwsOrganizationRequest enableSharingWithAwsOrganizationRequest) throws OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSharingWithAwsOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, enableSharingWithAwsOrganizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableSharingWithAwsOrganization");
            EnableSharingWithAwsOrganizationResponse enableSharingWithAwsOrganizationResponse = (EnableSharingWithAwsOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSharingWithAwsOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableSharingWithAwsOrganizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableSharingWithAwsOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableSharingWithAwsOrganizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$enableSharingWithAwsOrganization$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPermissionResponse getPermission(GetPermissionRequest getPermissionRequest) throws InvalidParameterException, MalformedArnException, UnknownResourceException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPermissionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, getPermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPermission");
            GetPermissionResponse getPermissionResponse = (GetPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPermission").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPermissionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPermissionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getPermission$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePoliciesResponse getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest) throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePoliciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, getResourcePoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicies");
            GetResourcePoliciesResponse getResourcePoliciesResponse = (GetResourcePoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourcePoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourcePolicies$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetResourcePoliciesIterable getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest) throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ResourceArnNotFoundException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourcePoliciesIterable(this, this.applyPaginatorUserAgent(getResourcePoliciesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceShareAssociationsResponse getResourceShareAssociations(GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceShareAssociationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, getResourceShareAssociationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShareAssociations");
            GetResourceShareAssociationsResponse getResourceShareAssociationsResponse = (GetResourceShareAssociationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShareAssociations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceShareAssociationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceShareAssociationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceShareAssociationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourceShareAssociations$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetResourceShareAssociationsIterable getResourceShareAssociationsPaginator(GetResourceShareAssociationsRequest getResourceShareAssociationsRequest) throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourceShareAssociationsIterable(this, this.applyPaginatorUserAgent(getResourceShareAssociationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceShareInvitationsResponse getResourceShareInvitations(GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceShareInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, getResourceShareInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShareInvitations");
            GetResourceShareInvitationsResponse getResourceShareInvitationsResponse = (GetResourceShareInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShareInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceShareInvitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceShareInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceShareInvitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourceShareInvitations$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetResourceShareInvitationsIterable getResourceShareInvitationsPaginator(GetResourceShareInvitationsRequest getResourceShareInvitationsRequest) throws ResourceShareInvitationArnNotFoundException, InvalidMaxResultsException, MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourceShareInvitationsIterable(this, this.applyPaginatorUserAgent(getResourceShareInvitationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceSharesResponse getResourceShares(GetResourceSharesRequest getResourceSharesRequest) throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceSharesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, getResourceSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceShares");
            GetResourceSharesResponse getResourceSharesResponse = (GetResourceSharesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceShares").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getResourceSharesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceSharesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$getResourceShares$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetResourceSharesIterable getResourceSharesPaginator(GetResourceSharesRequest getResourceSharesRequest) throws UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new GetResourceSharesIterable(this, this.applyPaginatorUserAgent(getResourceSharesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPendingInvitationResourcesResponse listPendingInvitationResources(ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPendingInvitationResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, listPendingInvitationResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPendingInvitationResources");
            ListPendingInvitationResourcesResponse listPendingInvitationResourcesResponse = (ListPendingInvitationResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPendingInvitationResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPendingInvitationResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPendingInvitationResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPendingInvitationResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPendingInvitationResources$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPendingInvitationResourcesIterable listPendingInvitationResourcesPaginator(ListPendingInvitationResourcesRequest listPendingInvitationResourcesRequest) throws MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, ResourceShareInvitationArnNotFoundException, MissingRequiredParameterException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, AwsServiceException, SdkClientException, RamException {
        return new ListPendingInvitationResourcesIterable(this, this.applyPaginatorUserAgent(listPendingInvitationResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionsResponse listPermissions(ListPermissionsRequest listPermissionsRequest) throws InvalidParameterException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, listPermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPermissions");
            ListPermissionsResponse listPermissionsResponse = (ListPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPermissions$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPrincipalsResponse listPrincipals(ListPrincipalsRequest listPrincipalsRequest) throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPrincipalsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, listPrincipalsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPrincipals");
            ListPrincipalsResponse listPrincipalsResponse = (ListPrincipalsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPrincipals").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPrincipalsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPrincipalsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPrincipalsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listPrincipals$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListPrincipalsIterable listPrincipalsPaginator(ListPrincipalsRequest listPrincipalsRequest) throws MalformedArnException, UnknownResourceException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new ListPrincipalsIterable(this, this.applyPaginatorUserAgent(listPrincipalsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceSharePermissionsResponse listResourceSharePermissions(ListResourceSharePermissionsRequest listResourceSharePermissionsRequest) throws InvalidParameterException, MalformedArnException, UnknownResourceException, InvalidNextTokenException, ServerInternalException, ServiceUnavailableException, OperationNotPermittedException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceSharePermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, listResourceSharePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceSharePermissions");
            ListResourceSharePermissionsResponse listResourceSharePermissionsResponse = (ListResourceSharePermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceSharePermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceSharePermissionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceSharePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceSharePermissionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listResourceSharePermissions$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceTypesResponse listResourceTypes(ListResourceTypesRequest listResourceTypesRequest) throws InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, listResourceTypesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceTypes");
            ListResourceTypesResponse listResourceTypesResponse = (ListResourceTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceTypesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceTypesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listResourceTypes$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidResourceTypeException, UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            ListResourcesResponse listResourcesResponse = (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$listResources$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws InvalidResourceTypeException, UnknownResourceException, MalformedArnException, InvalidNextTokenException, InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        return new ListResourcesIterable(this, this.applyPaginatorUserAgent(listResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PromoteResourceShareCreatedFromPolicyResponse promoteResourceShareCreatedFromPolicy(PromoteResourceShareCreatedFromPolicyRequest promoteResourceShareCreatedFromPolicyRequest) throws MalformedArnException, OperationNotPermittedException, InvalidParameterException, MissingRequiredParameterException, ServerInternalException, ServiceUnavailableException, UnknownResourceException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PromoteResourceShareCreatedFromPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, promoteResourceShareCreatedFromPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PromoteResourceShareCreatedFromPolicy");
            PromoteResourceShareCreatedFromPolicyResponse promoteResourceShareCreatedFromPolicyResponse = (PromoteResourceShareCreatedFromPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromoteResourceShareCreatedFromPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)promoteResourceShareCreatedFromPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PromoteResourceShareCreatedFromPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return promoteResourceShareCreatedFromPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$promoteResourceShareCreatedFromPolicy$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectResourceShareInvitationResponse rejectResourceShareInvitation(RejectResourceShareInvitationRequest rejectResourceShareInvitationRequest) throws MalformedArnException, OperationNotPermittedException, ResourceShareInvitationArnNotFoundException, ResourceShareInvitationAlreadyAcceptedException, ResourceShareInvitationAlreadyRejectedException, ResourceShareInvitationExpiredException, ServerInternalException, ServiceUnavailableException, InvalidClientTokenException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectResourceShareInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, rejectResourceShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectResourceShareInvitation");
            RejectResourceShareInvitationResponse rejectResourceShareInvitationResponse = (RejectResourceShareInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectResourceShareInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectResourceShareInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectResourceShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectResourceShareInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$rejectResourceShareInvitation$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, MalformedArnException, TagLimitExceededException, ResourceArnNotFoundException, TagPolicyViolationException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$tagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$untagResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceShareResponse updateResourceShare(UpdateResourceShareRequest updateResourceShareRequest) throws IdempotentParameterMismatchException, MissingRequiredParameterException, UnknownResourceException, MalformedArnException, InvalidClientTokenException, InvalidParameterException, OperationNotPermittedException, ServerInternalException, ServiceUnavailableException, AwsServiceException, SdkClientException, RamException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultRamClient.resolveMetricPublishers(this.clientConfiguration, updateResourceShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"RAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResourceShare");
            UpdateResourceShareResponse updateResourceShareResponse = (UpdateResourceShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResourceShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRamClient.lambda$updateResourceShare$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RamException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidClientTokenException").exceptionBuilderSupplier(InvalidClientTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownResourceException").exceptionBuilderSupplier(UnknownResourceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServerInternalException").exceptionBuilderSupplier(ServerInternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").exceptionBuilderSupplier(InvalidMaxResultsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceTypeException").exceptionBuilderSupplier(InvalidResourceTypeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceShareInvitationExpiredException").exceptionBuilderSupplier(ResourceShareInvitationExpiredException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingRequiredParameterException").exceptionBuilderSupplier(MissingRequiredParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagLimitExceededException").exceptionBuilderSupplier(TagLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceArnNotFoundException").exceptionBuilderSupplier(ResourceArnNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceShareLimitExceededException").exceptionBuilderSupplier(ResourceShareLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyRejectedException").exceptionBuilderSupplier(ResourceShareInvitationAlreadyRejectedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MalformedArnException").exceptionBuilderSupplier(MalformedArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceShareInvitationAlreadyAcceptedException").exceptionBuilderSupplier(ResourceShareInvitationAlreadyAcceptedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceShareInvitationArnNotFoundException").exceptionBuilderSupplier(ResourceShareInvitationArnNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagPolicyViolationException").exceptionBuilderSupplier(TagPolicyViolationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends RamRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.11").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RamRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateResourceShare$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectResourceShareInvitation$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$promoteResourceShareCreatedFromPolicy$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceTypes$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceSharePermissions$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPrincipals$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPermissions$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPendingInvitationResources$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShares$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShareInvitations$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceShareAssociations$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicies$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPermission$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableSharingWithAwsOrganization$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceSharePermission$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateResourceShare$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourceShare$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResourceShare$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceSharePermission$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateResourceShare$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptResourceShareInvitation$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

