/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSetColumnIdMapping;
import software.amazon.awssdk.services.quicksight.model.DataSetColumnIdMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformOperationSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformOperationSource> {
    private static final SdkField<String> TRANSFORM_OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformOperationId").getter(TransformOperationSource.getter(TransformOperationSource::transformOperationId)).setter(TransformOperationSource.setter(Builder::transformOperationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOperationId").build()}).build();
    private static final SdkField<List<DataSetColumnIdMapping>> COLUMN_ID_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnIdMappings").getter(TransformOperationSource.getter(TransformOperationSource::columnIdMappings)).setter(TransformOperationSource.setter(Builder::columnIdMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnIdMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetColumnIdMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_OPERATION_ID_FIELD, COLUMN_ID_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransformOperationSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transformOperationId;
    private final List<DataSetColumnIdMapping> columnIdMappings;

    private TransformOperationSource(BuilderImpl builder) {
        this.transformOperationId = builder.transformOperationId;
        this.columnIdMappings = builder.columnIdMappings;
    }

    public final String transformOperationId() {
        return this.transformOperationId;
    }

    public final boolean hasColumnIdMappings() {
        return this.columnIdMappings != null && !(this.columnIdMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSetColumnIdMapping> columnIdMappings() {
        return this.columnIdMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnIdMappings() ? this.columnIdMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOperationSource)) {
            return false;
        }
        TransformOperationSource other = (TransformOperationSource)obj;
        return Objects.equals(this.transformOperationId(), other.transformOperationId()) && this.hasColumnIdMappings() == other.hasColumnIdMappings() && Objects.equals(this.columnIdMappings(), other.columnIdMappings());
    }

    public final String toString() {
        return ToString.builder((String)"TransformOperationSource").add("TransformOperationId", (Object)this.transformOperationId()).add("ColumnIdMappings", this.hasColumnIdMappings() ? this.columnIdMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformOperationId": {
                return Optional.ofNullable(clazz.cast(this.transformOperationId()));
            }
            case "ColumnIdMappings": {
                return Optional.ofNullable(clazz.cast(this.columnIdMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransformOperationId", TRANSFORM_OPERATION_ID_FIELD);
        map.put("ColumnIdMappings", COLUMN_ID_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformOperationSource, T> g) {
        return obj -> g.apply((TransformOperationSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformOperationId;
        private List<DataSetColumnIdMapping> columnIdMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOperationSource model) {
            this.transformOperationId(model.transformOperationId);
            this.columnIdMappings(model.columnIdMappings);
        }

        public final String getTransformOperationId() {
            return this.transformOperationId;
        }

        public final void setTransformOperationId(String transformOperationId) {
            this.transformOperationId = transformOperationId;
        }

        @Override
        public final Builder transformOperationId(String transformOperationId) {
            this.transformOperationId = transformOperationId;
            return this;
        }

        public final List<DataSetColumnIdMapping.Builder> getColumnIdMappings() {
            List<DataSetColumnIdMapping.Builder> result = DataSetColumnIdMappingListCopier.copyToBuilder(this.columnIdMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnIdMappings(Collection<DataSetColumnIdMapping.BuilderImpl> columnIdMappings) {
            this.columnIdMappings = DataSetColumnIdMappingListCopier.copyFromBuilder(columnIdMappings);
        }

        @Override
        public final Builder columnIdMappings(Collection<DataSetColumnIdMapping> columnIdMappings) {
            this.columnIdMappings = DataSetColumnIdMappingListCopier.copy(columnIdMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnIdMappings(DataSetColumnIdMapping ... columnIdMappings) {
            this.columnIdMappings(Arrays.asList(columnIdMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnIdMappings(Consumer<DataSetColumnIdMapping.Builder> ... columnIdMappings) {
            this.columnIdMappings(Stream.of(columnIdMappings).map(c -> (DataSetColumnIdMapping)((DataSetColumnIdMapping.Builder)DataSetColumnIdMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransformOperationSource build() {
            return new TransformOperationSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformOperationSource> {
        public Builder transformOperationId(String var1);

        public Builder columnIdMappings(Collection<DataSetColumnIdMapping> var1);

        public Builder columnIdMappings(DataSetColumnIdMapping ... var1);

        public Builder columnIdMappings(Consumer<DataSetColumnIdMapping.Builder> ... var1);
    }
}

