/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FontConfiguration;
import software.amazon.awssdk.services.quicksight.model.HorizontalTextAlignment;
import software.amazon.awssdk.services.quicksight.model.TextTransform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisualTitleFontConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisualTitleFontConfiguration> {
    private static final SdkField<FontConfiguration> FONT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FontConfiguration").getter(VisualTitleFontConfiguration.getter(VisualTitleFontConfiguration::fontConfiguration)).setter(VisualTitleFontConfiguration.setter(Builder::fontConfiguration)).constructor(FontConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FontConfiguration").build()}).build();
    private static final SdkField<String> TEXT_ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextAlignment").getter(VisualTitleFontConfiguration.getter(VisualTitleFontConfiguration::textAlignmentAsString)).setter(VisualTitleFontConfiguration.setter(Builder::textAlignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextAlignment").build()}).build();
    private static final SdkField<String> TEXT_TRANSFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextTransform").getter(VisualTitleFontConfiguration.getter(VisualTitleFontConfiguration::textTransformAsString)).setter(VisualTitleFontConfiguration.setter(Builder::textTransform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FONT_CONFIGURATION_FIELD, TEXT_ALIGNMENT_FIELD, TEXT_TRANSFORM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VisualTitleFontConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FontConfiguration fontConfiguration;
    private final String textAlignment;
    private final String textTransform;

    private VisualTitleFontConfiguration(BuilderImpl builder) {
        this.fontConfiguration = builder.fontConfiguration;
        this.textAlignment = builder.textAlignment;
        this.textTransform = builder.textTransform;
    }

    public final FontConfiguration fontConfiguration() {
        return this.fontConfiguration;
    }

    public final HorizontalTextAlignment textAlignment() {
        return HorizontalTextAlignment.fromValue(this.textAlignment);
    }

    public final String textAlignmentAsString() {
        return this.textAlignment;
    }

    public final TextTransform textTransform() {
        return TextTransform.fromValue(this.textTransform);
    }

    public final String textTransformAsString() {
        return this.textTransform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fontConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.textAlignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTransformAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualTitleFontConfiguration)) {
            return false;
        }
        VisualTitleFontConfiguration other = (VisualTitleFontConfiguration)obj;
        return Objects.equals(this.fontConfiguration(), other.fontConfiguration()) && Objects.equals(this.textAlignmentAsString(), other.textAlignmentAsString()) && Objects.equals(this.textTransformAsString(), other.textTransformAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VisualTitleFontConfiguration").add("FontConfiguration", (Object)this.fontConfiguration()).add("TextAlignment", (Object)this.textAlignmentAsString()).add("TextTransform", (Object)this.textTransformAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FontConfiguration": {
                return Optional.ofNullable(clazz.cast(this.fontConfiguration()));
            }
            case "TextAlignment": {
                return Optional.ofNullable(clazz.cast(this.textAlignmentAsString()));
            }
            case "TextTransform": {
                return Optional.ofNullable(clazz.cast(this.textTransformAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FontConfiguration", FONT_CONFIGURATION_FIELD);
        map.put("TextAlignment", TEXT_ALIGNMENT_FIELD);
        map.put("TextTransform", TEXT_TRANSFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualTitleFontConfiguration, T> g) {
        return obj -> g.apply((VisualTitleFontConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FontConfiguration fontConfiguration;
        private String textAlignment;
        private String textTransform;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualTitleFontConfiguration model) {
            this.fontConfiguration(model.fontConfiguration);
            this.textAlignment(model.textAlignment);
            this.textTransform(model.textTransform);
        }

        public final FontConfiguration.Builder getFontConfiguration() {
            return this.fontConfiguration != null ? this.fontConfiguration.toBuilder() : null;
        }

        public final void setFontConfiguration(FontConfiguration.BuilderImpl fontConfiguration) {
            this.fontConfiguration = fontConfiguration != null ? fontConfiguration.build() : null;
        }

        @Override
        public final Builder fontConfiguration(FontConfiguration fontConfiguration) {
            this.fontConfiguration = fontConfiguration;
            return this;
        }

        public final String getTextAlignment() {
            return this.textAlignment;
        }

        public final void setTextAlignment(String textAlignment) {
            this.textAlignment = textAlignment;
        }

        @Override
        public final Builder textAlignment(String textAlignment) {
            this.textAlignment = textAlignment;
            return this;
        }

        @Override
        public final Builder textAlignment(HorizontalTextAlignment textAlignment) {
            this.textAlignment(textAlignment == null ? null : textAlignment.toString());
            return this;
        }

        public final String getTextTransform() {
            return this.textTransform;
        }

        public final void setTextTransform(String textTransform) {
            this.textTransform = textTransform;
        }

        @Override
        public final Builder textTransform(String textTransform) {
            this.textTransform = textTransform;
            return this;
        }

        @Override
        public final Builder textTransform(TextTransform textTransform) {
            this.textTransform(textTransform == null ? null : textTransform.toString());
            return this;
        }

        public VisualTitleFontConfiguration build() {
            return new VisualTitleFontConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisualTitleFontConfiguration> {
        public Builder fontConfiguration(FontConfiguration var1);

        default public Builder fontConfiguration(Consumer<FontConfiguration.Builder> fontConfiguration) {
            return this.fontConfiguration((FontConfiguration)((FontConfiguration.Builder)FontConfiguration.builder().applyMutation(fontConfiguration)).build());
        }

        public Builder textAlignment(String var1);

        public Builder textAlignment(HorizontalTextAlignment var1);

        public Builder textTransform(String var1);

        public Builder textTransform(TextTransform var1);
    }
}

