/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Permission;
import software.amazon.awssdk.services.quicksight.model.PermissionsListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFlowPermissionsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateFlowPermissionsResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateFlowPermissionsResponse.getter(UpdateFlowPermissionsResponse::status)).setter(UpdateFlowPermissionsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateFlowPermissionsResponse.getter(UpdateFlowPermissionsResponse::arn)).setter(UpdateFlowPermissionsResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<Permission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(UpdateFlowPermissionsResponse.getter(UpdateFlowPermissionsResponse::permissions)).setter(UpdateFlowPermissionsResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Permission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateFlowPermissionsResponse.getter(UpdateFlowPermissionsResponse::requestId)).setter(UpdateFlowPermissionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowId").getter(UpdateFlowPermissionsResponse.getter(UpdateFlowPermissionsResponse::flowId)).setter(UpdateFlowPermissionsResponse.setter(Builder::flowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ARN_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD, FLOW_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFlowPermissionsResponse.memberNameToFieldInitializer();
    private final Integer status;
    private final String arn;
    private final List<Permission> permissions;
    private final String requestId;
    private final String flowId;

    private UpdateFlowPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.arn = builder.arn;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
        this.flowId = builder.flowId;
    }

    public final Integer status() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<Permission> permissions() {
        return this.permissions;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String flowId() {
        return this.flowId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowPermissionsResponse)) {
            return false;
        }
        UpdateFlowPermissionsResponse other = (UpdateFlowPermissionsResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.arn(), other.arn()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.flowId(), other.flowId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFlowPermissionsResponse").add("Status", (Object)this.status()).add("Arn", (Object)this.arn()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("RequestId", (Object)this.requestId()).add("FlowId", (Object)this.flowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "FlowId": {
                return Optional.ofNullable(clazz.cast(this.flowId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("FlowId", FLOW_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowPermissionsResponse, T> g) {
        return obj -> g.apply((UpdateFlowPermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String arn;
        private List<Permission> permissions = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private String flowId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowPermissionsResponse model) {
            super(model);
            this.status(model.status);
            this.arn(model.arn);
            this.permissions(model.permissions);
            this.requestId(model.requestId);
            this.flowId(model.flowId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<Permission.Builder> getPermissions() {
            List<Permission.Builder> result = PermissionsListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (Permission)((Permission.Builder)Permission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getFlowId() {
            return this.flowId;
        }

        public final void setFlowId(String flowId) {
            this.flowId = flowId;
        }

        @Override
        public final Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Override
        public UpdateFlowPermissionsResponse build() {
            return new UpdateFlowPermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFlowPermissionsResponse> {
        public Builder status(Integer var1);

        public Builder arn(String var1);

        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);

        public Builder permissions(Consumer<Permission.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder flowId(String var1);
    }
}

