/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.InputColumn;
import software.amazon.awssdk.services.quicksight.model.InputColumnListCopier;
import software.amazon.awssdk.services.quicksight.model.TablePathElement;
import software.amazon.awssdk.services.quicksight.model.TablePathElementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SaaSTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SaaSTable> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceArn").getter(SaaSTable.getter(SaaSTable::dataSourceArn)).setter(SaaSTable.setter(Builder::dataSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()}).build();
    private static final SdkField<List<TablePathElement>> TABLE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TablePath").getter(SaaSTable.getter(SaaSTable::tablePath)).setter(SaaSTable.setter(Builder::tablePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TablePathElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputColumns").getter(SaaSTable.getter(SaaSTable::inputColumns)).setter(SaaSTable.setter(Builder::inputColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD, TABLE_PATH_FIELD, INPUT_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SaaSTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSourceArn;
    private final List<TablePathElement> tablePath;
    private final List<InputColumn> inputColumns;

    private SaaSTable(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.tablePath = builder.tablePath;
        this.inputColumns = builder.inputColumns;
    }

    public final String dataSourceArn() {
        return this.dataSourceArn;
    }

    public final boolean hasTablePath() {
        return this.tablePath != null && !(this.tablePath instanceof SdkAutoConstructList);
    }

    public final List<TablePathElement> tablePath() {
        return this.tablePath;
    }

    public final boolean hasInputColumns() {
        return this.inputColumns != null && !(this.inputColumns instanceof SdkAutoConstructList);
    }

    public final List<InputColumn> inputColumns() {
        return this.inputColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTablePath() ? this.tablePath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputColumns() ? this.inputColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SaaSTable)) {
            return false;
        }
        SaaSTable other = (SaaSTable)obj;
        return Objects.equals(this.dataSourceArn(), other.dataSourceArn()) && this.hasTablePath() == other.hasTablePath() && Objects.equals(this.tablePath(), other.tablePath()) && this.hasInputColumns() == other.hasInputColumns() && Objects.equals(this.inputColumns(), other.inputColumns());
    }

    public final String toString() {
        return ToString.builder((String)"SaaSTable").add("DataSourceArn", (Object)this.dataSourceArn()).add("TablePath", this.hasTablePath() ? this.tablePath() : null).add("InputColumns", this.hasInputColumns() ? this.inputColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceArn()));
            }
            case "TablePath": {
                return Optional.ofNullable(clazz.cast(this.tablePath()));
            }
            case "InputColumns": {
                return Optional.ofNullable(clazz.cast(this.inputColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSourceArn", DATA_SOURCE_ARN_FIELD);
        map.put("TablePath", TABLE_PATH_FIELD);
        map.put("InputColumns", INPUT_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SaaSTable, T> g) {
        return obj -> g.apply((SaaSTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceArn;
        private List<TablePathElement> tablePath = DefaultSdkAutoConstructList.getInstance();
        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SaaSTable model) {
            this.dataSourceArn(model.dataSourceArn);
            this.tablePath(model.tablePath);
            this.inputColumns(model.inputColumns);
        }

        public final String getDataSourceArn() {
            return this.dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final List<TablePathElement.Builder> getTablePath() {
            List<TablePathElement.Builder> result = TablePathElementListCopier.copyToBuilder(this.tablePath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTablePath(Collection<TablePathElement.BuilderImpl> tablePath) {
            this.tablePath = TablePathElementListCopier.copyFromBuilder(tablePath);
        }

        @Override
        public final Builder tablePath(Collection<TablePathElement> tablePath) {
            this.tablePath = TablePathElementListCopier.copy(tablePath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablePath(TablePathElement ... tablePath) {
            this.tablePath(Arrays.asList(tablePath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablePath(Consumer<TablePathElement.Builder> ... tablePath) {
            this.tablePath(Stream.of(tablePath).map(c -> (TablePathElement)((TablePathElement.Builder)TablePathElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InputColumn.Builder> getInputColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.inputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn ... inputColumns) {
            this.inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder> ... inputColumns) {
            this.inputColumns(Stream.of(inputColumns).map(c -> (InputColumn)((InputColumn.Builder)InputColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SaaSTable build() {
            return new SaaSTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SaaSTable> {
        public Builder dataSourceArn(String var1);

        public Builder tablePath(Collection<TablePathElement> var1);

        public Builder tablePath(TablePathElement ... var1);

        public Builder tablePath(Consumer<TablePathElement.Builder> ... var1);

        public Builder inputColumns(Collection<InputColumn> var1);

        public Builder inputColumns(InputColumn ... var1);

        public Builder inputColumns(Consumer<InputColumn.Builder> ... var1);
    }
}

