/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.Coordinate;
import software.amazon.awssdk.services.quicksight.model.GeocoderHierarchy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeocodePreferenceValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeocodePreferenceValue> {
    private static final SdkField<GeocoderHierarchy> GEOCODER_HIERARCHY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GeocoderHierarchy").getter(GeocodePreferenceValue.getter(GeocodePreferenceValue::geocoderHierarchy)).setter(GeocodePreferenceValue.setter(Builder::geocoderHierarchy)).constructor(GeocoderHierarchy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeocoderHierarchy").build()}).build();
    private static final SdkField<Coordinate> COORDINATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Coordinate").getter(GeocodePreferenceValue.getter(GeocodePreferenceValue::coordinate)).setter(GeocodePreferenceValue.setter(Builder::coordinate)).constructor(Coordinate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coordinate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GEOCODER_HIERARCHY_FIELD, COORDINATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeocodePreferenceValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GeocoderHierarchy geocoderHierarchy;
    private final Coordinate coordinate;
    private final Type type;

    private GeocodePreferenceValue(BuilderImpl builder) {
        this.geocoderHierarchy = builder.geocoderHierarchy;
        this.coordinate = builder.coordinate;
        this.type = builder.type;
    }

    public final GeocoderHierarchy geocoderHierarchy() {
        return this.geocoderHierarchy;
    }

    public final Coordinate coordinate() {
        return this.coordinate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.geocoderHierarchy());
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeocodePreferenceValue)) {
            return false;
        }
        GeocodePreferenceValue other = (GeocodePreferenceValue)obj;
        return Objects.equals(this.geocoderHierarchy(), other.geocoderHierarchy()) && Objects.equals(this.coordinate(), other.coordinate());
    }

    public final String toString() {
        return ToString.builder((String)"GeocodePreferenceValue").add("GeocoderHierarchy", (Object)this.geocoderHierarchy()).add("Coordinate", (Object)this.coordinate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeocoderHierarchy": {
                return Optional.ofNullable(clazz.cast(this.geocoderHierarchy()));
            }
            case "Coordinate": {
                return Optional.ofNullable(clazz.cast(this.coordinate()));
            }
        }
        return Optional.empty();
    }

    public static GeocodePreferenceValue fromGeocoderHierarchy(GeocoderHierarchy geocoderHierarchy) {
        return (GeocodePreferenceValue)GeocodePreferenceValue.builder().geocoderHierarchy(geocoderHierarchy).build();
    }

    public static GeocodePreferenceValue fromGeocoderHierarchy(Consumer<GeocoderHierarchy.Builder> geocoderHierarchy) {
        GeocoderHierarchy.Builder builder = GeocoderHierarchy.builder();
        geocoderHierarchy.accept(builder);
        return GeocodePreferenceValue.fromGeocoderHierarchy((GeocoderHierarchy)builder.build());
    }

    public static GeocodePreferenceValue fromCoordinate(Coordinate coordinate) {
        return (GeocodePreferenceValue)GeocodePreferenceValue.builder().coordinate(coordinate).build();
    }

    public static GeocodePreferenceValue fromCoordinate(Consumer<Coordinate.Builder> coordinate) {
        Coordinate.Builder builder = Coordinate.builder();
        coordinate.accept(builder);
        return GeocodePreferenceValue.fromCoordinate((Coordinate)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GeocoderHierarchy", GEOCODER_HIERARCHY_FIELD);
        map.put("Coordinate", COORDINATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeocodePreferenceValue, T> g) {
        return obj -> g.apply((GeocodePreferenceValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GEOCODER_HIERARCHY,
        COORDINATE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GeocoderHierarchy geocoderHierarchy;
        private Coordinate coordinate;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GeocodePreferenceValue model) {
            this.geocoderHierarchy(model.geocoderHierarchy);
            this.coordinate(model.coordinate);
        }

        public final GeocoderHierarchy.Builder getGeocoderHierarchy() {
            return this.geocoderHierarchy != null ? this.geocoderHierarchy.toBuilder() : null;
        }

        public final void setGeocoderHierarchy(GeocoderHierarchy.BuilderImpl geocoderHierarchy) {
            GeocoderHierarchy oldValue = this.geocoderHierarchy;
            this.geocoderHierarchy = geocoderHierarchy != null ? geocoderHierarchy.build() : null;
            this.handleUnionValueChange(Type.GEOCODER_HIERARCHY, oldValue, this.geocoderHierarchy);
        }

        @Override
        public final Builder geocoderHierarchy(GeocoderHierarchy geocoderHierarchy) {
            GeocoderHierarchy oldValue = this.geocoderHierarchy;
            this.geocoderHierarchy = geocoderHierarchy;
            this.handleUnionValueChange(Type.GEOCODER_HIERARCHY, oldValue, this.geocoderHierarchy);
            return this;
        }

        public final Coordinate.Builder getCoordinate() {
            return this.coordinate != null ? this.coordinate.toBuilder() : null;
        }

        public final void setCoordinate(Coordinate.BuilderImpl coordinate) {
            Coordinate oldValue = this.coordinate;
            this.coordinate = coordinate != null ? coordinate.build() : null;
            this.handleUnionValueChange(Type.COORDINATE, oldValue, this.coordinate);
        }

        @Override
        public final Builder coordinate(Coordinate coordinate) {
            Coordinate oldValue = this.coordinate;
            this.coordinate = coordinate;
            this.handleUnionValueChange(Type.COORDINATE, oldValue, this.coordinate);
            return this;
        }

        public GeocodePreferenceValue build() {
            return new GeocodePreferenceValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeocodePreferenceValue> {
        public Builder geocoderHierarchy(GeocoderHierarchy var1);

        default public Builder geocoderHierarchy(Consumer<GeocoderHierarchy.Builder> geocoderHierarchy) {
            return this.geocoderHierarchy((GeocoderHierarchy)((GeocoderHierarchy.Builder)GeocoderHierarchy.builder().applyMutation(geocoderHierarchy)).build());
        }

        public Builder coordinate(Coordinate var1);

        default public Builder coordinate(Consumer<Coordinate.Builder> coordinate) {
            return this.coordinate((Coordinate)((Coordinate.Builder)Coordinate.builder().applyMutation(coordinate)).build());
        }
    }
}

