/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSetDateFilterCondition;
import software.amazon.awssdk.services.quicksight.model.DataSetNumericFilterCondition;
import software.amazon.awssdk.services.quicksight.model.DataSetStringFilterCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterOperation> {
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionExpression").getter(FilterOperation.getter(FilterOperation::conditionExpression)).setter(FilterOperation.setter(Builder::conditionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build()}).build();
    private static final SdkField<DataSetStringFilterCondition> STRING_FILTER_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringFilterCondition").getter(FilterOperation.getter(FilterOperation::stringFilterCondition)).setter(FilterOperation.setter(Builder::stringFilterCondition)).constructor(DataSetStringFilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilterCondition").build()}).build();
    private static final SdkField<DataSetNumericFilterCondition> NUMERIC_FILTER_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NumericFilterCondition").getter(FilterOperation.getter(FilterOperation::numericFilterCondition)).setter(FilterOperation.setter(Builder::numericFilterCondition)).constructor(DataSetNumericFilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericFilterCondition").build()}).build();
    private static final SdkField<DataSetDateFilterCondition> DATE_FILTER_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DateFilterCondition").getter(FilterOperation.getter(FilterOperation::dateFilterCondition)).setter(FilterOperation.setter(Builder::dateFilterCondition)).constructor(DataSetDateFilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFilterCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_EXPRESSION_FIELD, STRING_FILTER_CONDITION_FIELD, NUMERIC_FILTER_CONDITION_FIELD, DATE_FILTER_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String conditionExpression;
    private final DataSetStringFilterCondition stringFilterCondition;
    private final DataSetNumericFilterCondition numericFilterCondition;
    private final DataSetDateFilterCondition dateFilterCondition;

    private FilterOperation(BuilderImpl builder) {
        this.conditionExpression = builder.conditionExpression;
        this.stringFilterCondition = builder.stringFilterCondition;
        this.numericFilterCondition = builder.numericFilterCondition;
        this.dateFilterCondition = builder.dateFilterCondition;
    }

    public final String conditionExpression() {
        return this.conditionExpression;
    }

    public final DataSetStringFilterCondition stringFilterCondition() {
        return this.stringFilterCondition;
    }

    public final DataSetNumericFilterCondition numericFilterCondition() {
        return this.numericFilterCondition;
    }

    public final DataSetDateFilterCondition dateFilterCondition() {
        return this.dateFilterCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringFilterCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.numericFilterCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateFilterCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperation)) {
            return false;
        }
        FilterOperation other = (FilterOperation)obj;
        return Objects.equals(this.conditionExpression(), other.conditionExpression()) && Objects.equals(this.stringFilterCondition(), other.stringFilterCondition()) && Objects.equals(this.numericFilterCondition(), other.numericFilterCondition()) && Objects.equals(this.dateFilterCondition(), other.dateFilterCondition());
    }

    public final String toString() {
        return ToString.builder((String)"FilterOperation").add("ConditionExpression", (Object)(this.conditionExpression() == null ? null : "*** Sensitive Data Redacted ***")).add("StringFilterCondition", (Object)this.stringFilterCondition()).add("NumericFilterCondition", (Object)this.numericFilterCondition()).add("DateFilterCondition", (Object)this.dateFilterCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConditionExpression": {
                return Optional.ofNullable(clazz.cast(this.conditionExpression()));
            }
            case "StringFilterCondition": {
                return Optional.ofNullable(clazz.cast(this.stringFilterCondition()));
            }
            case "NumericFilterCondition": {
                return Optional.ofNullable(clazz.cast(this.numericFilterCondition()));
            }
            case "DateFilterCondition": {
                return Optional.ofNullable(clazz.cast(this.dateFilterCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConditionExpression", CONDITION_EXPRESSION_FIELD);
        map.put("StringFilterCondition", STRING_FILTER_CONDITION_FIELD);
        map.put("NumericFilterCondition", NUMERIC_FILTER_CONDITION_FIELD);
        map.put("DateFilterCondition", DATE_FILTER_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterOperation, T> g) {
        return obj -> g.apply((FilterOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conditionExpression;
        private DataSetStringFilterCondition stringFilterCondition;
        private DataSetNumericFilterCondition numericFilterCondition;
        private DataSetDateFilterCondition dateFilterCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterOperation model) {
            this.conditionExpression(model.conditionExpression);
            this.stringFilterCondition(model.stringFilterCondition);
            this.numericFilterCondition(model.numericFilterCondition);
            this.dateFilterCondition(model.dateFilterCondition);
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final DataSetStringFilterCondition.Builder getStringFilterCondition() {
            return this.stringFilterCondition != null ? this.stringFilterCondition.toBuilder() : null;
        }

        public final void setStringFilterCondition(DataSetStringFilterCondition.BuilderImpl stringFilterCondition) {
            this.stringFilterCondition = stringFilterCondition != null ? stringFilterCondition.build() : null;
        }

        @Override
        public final Builder stringFilterCondition(DataSetStringFilterCondition stringFilterCondition) {
            this.stringFilterCondition = stringFilterCondition;
            return this;
        }

        public final DataSetNumericFilterCondition.Builder getNumericFilterCondition() {
            return this.numericFilterCondition != null ? this.numericFilterCondition.toBuilder() : null;
        }

        public final void setNumericFilterCondition(DataSetNumericFilterCondition.BuilderImpl numericFilterCondition) {
            this.numericFilterCondition = numericFilterCondition != null ? numericFilterCondition.build() : null;
        }

        @Override
        public final Builder numericFilterCondition(DataSetNumericFilterCondition numericFilterCondition) {
            this.numericFilterCondition = numericFilterCondition;
            return this;
        }

        public final DataSetDateFilterCondition.Builder getDateFilterCondition() {
            return this.dateFilterCondition != null ? this.dateFilterCondition.toBuilder() : null;
        }

        public final void setDateFilterCondition(DataSetDateFilterCondition.BuilderImpl dateFilterCondition) {
            this.dateFilterCondition = dateFilterCondition != null ? dateFilterCondition.build() : null;
        }

        @Override
        public final Builder dateFilterCondition(DataSetDateFilterCondition dateFilterCondition) {
            this.dateFilterCondition = dateFilterCondition;
            return this;
        }

        public FilterOperation build() {
            return new FilterOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterOperation> {
        public Builder conditionExpression(String var1);

        public Builder stringFilterCondition(DataSetStringFilterCondition var1);

        default public Builder stringFilterCondition(Consumer<DataSetStringFilterCondition.Builder> stringFilterCondition) {
            return this.stringFilterCondition((DataSetStringFilterCondition)((DataSetStringFilterCondition.Builder)DataSetStringFilterCondition.builder().applyMutation(stringFilterCondition)).build());
        }

        public Builder numericFilterCondition(DataSetNumericFilterCondition var1);

        default public Builder numericFilterCondition(Consumer<DataSetNumericFilterCondition.Builder> numericFilterCondition) {
            return this.numericFilterCondition((DataSetNumericFilterCondition)((DataSetNumericFilterCondition.Builder)DataSetNumericFilterCondition.builder().applyMutation(numericFilterCondition)).build());
        }

        public Builder dateFilterCondition(DataSetDateFilterCondition var1);

        default public Builder dateFilterCondition(Consumer<DataSetDateFilterCondition.Builder> dateFilterCondition) {
            return this.dateFilterCondition((DataSetDateFilterCondition)((DataSetDateFilterCondition.Builder)DataSetDateFilterCondition.builder().applyMutation(dateFilterCondition)).build());
        }
    }
}

