/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.DataSetImportMode;
import software.amazon.awssdk.services.quicksight.model.DataSetUseAs;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionDataSet;
import software.amazon.awssdk.services.quicksight.model.RowLevelPermissionDataSetMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DataSetSummary.getter(DataSetSummary::arn)).setter(DataSetSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(DataSetSummary.getter(DataSetSummary::dataSetId)).setter(DataSetSummary.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataSetSummary.getter(DataSetSummary::name)).setter(DataSetSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DataSetSummary.getter(DataSetSummary::createdTime)).setter(DataSetSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DataSetSummary.getter(DataSetSummary::lastUpdatedTime)).setter(DataSetSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> IMPORT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportMode").getter(DataSetSummary.getter(DataSetSummary::importModeAsString)).setter(DataSetSummary.setter(Builder::importMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportMode").build()}).build();
    private static final SdkField<RowLevelPermissionDataSet> ROW_LEVEL_PERMISSION_DATA_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowLevelPermissionDataSet").getter(DataSetSummary.getter(DataSetSummary::rowLevelPermissionDataSet)).setter(DataSetSummary.setter(Builder::rowLevelPermissionDataSet)).constructor(RowLevelPermissionDataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSet").build()}).build();
    private static final SdkField<Map<String, RowLevelPermissionDataSet>> ROW_LEVEL_PERMISSION_DATA_SET_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RowLevelPermissionDataSetMap").getter(DataSetSummary.getter(DataSetSummary::rowLevelPermissionDataSetMap)).setter(DataSetSummary.setter(Builder::rowLevelPermissionDataSetMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionDataSetMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RowLevelPermissionDataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_APPLIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RowLevelPermissionTagConfigurationApplied").getter(DataSetSummary.getter(DataSetSummary::rowLevelPermissionTagConfigurationApplied)).setter(DataSetSummary.setter(Builder::rowLevelPermissionTagConfigurationApplied)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowLevelPermissionTagConfigurationApplied").build()}).build();
    private static final SdkField<Boolean> COLUMN_LEVEL_PERMISSION_RULES_APPLIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ColumnLevelPermissionRulesApplied").getter(DataSetSummary.getter(DataSetSummary::columnLevelPermissionRulesApplied)).setter(DataSetSummary.setter(Builder::columnLevelPermissionRulesApplied)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnLevelPermissionRulesApplied").build()}).build();
    private static final SdkField<String> USE_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseAs").getter(DataSetSummary.getter(DataSetSummary::useAsAsString)).setter(DataSetSummary.setter(Builder::useAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_SET_ID_FIELD, NAME_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, IMPORT_MODE_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_FIELD, ROW_LEVEL_PERMISSION_DATA_SET_MAP_FIELD, ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_APPLIED_FIELD, COLUMN_LEVEL_PERMISSION_RULES_APPLIED_FIELD, USE_AS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String dataSetId;
    private final String name;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String importMode;
    private final RowLevelPermissionDataSet rowLevelPermissionDataSet;
    private final Map<String, RowLevelPermissionDataSet> rowLevelPermissionDataSetMap;
    private final Boolean rowLevelPermissionTagConfigurationApplied;
    private final Boolean columnLevelPermissionRulesApplied;
    private final String useAs;

    private DataSetSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataSetId = builder.dataSetId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.importMode = builder.importMode;
        this.rowLevelPermissionDataSet = builder.rowLevelPermissionDataSet;
        this.rowLevelPermissionDataSetMap = builder.rowLevelPermissionDataSetMap;
        this.rowLevelPermissionTagConfigurationApplied = builder.rowLevelPermissionTagConfigurationApplied;
        this.columnLevelPermissionRulesApplied = builder.columnLevelPermissionRulesApplied;
        this.useAs = builder.useAs;
    }

    public final String arn() {
        return this.arn;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final DataSetImportMode importMode() {
        return DataSetImportMode.fromValue(this.importMode);
    }

    public final String importModeAsString() {
        return this.importMode;
    }

    public final RowLevelPermissionDataSet rowLevelPermissionDataSet() {
        return this.rowLevelPermissionDataSet;
    }

    public final boolean hasRowLevelPermissionDataSetMap() {
        return this.rowLevelPermissionDataSetMap != null && !(this.rowLevelPermissionDataSetMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, RowLevelPermissionDataSet> rowLevelPermissionDataSetMap() {
        return this.rowLevelPermissionDataSetMap;
    }

    public final Boolean rowLevelPermissionTagConfigurationApplied() {
        return this.rowLevelPermissionTagConfigurationApplied;
    }

    public final Boolean columnLevelPermissionRulesApplied() {
        return this.columnLevelPermissionRulesApplied;
    }

    public final DataSetUseAs useAs() {
        return DataSetUseAs.fromValue(this.useAs);
    }

    public final String useAsAsString() {
        return this.useAs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLevelPermissionDataSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRowLevelPermissionDataSetMap() ? this.rowLevelPermissionDataSetMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rowLevelPermissionTagConfigurationApplied());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnLevelPermissionRulesApplied());
        hashCode = 31 * hashCode + Objects.hashCode(this.useAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetSummary)) {
            return false;
        }
        DataSetSummary other = (DataSetSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.importModeAsString(), other.importModeAsString()) && Objects.equals(this.rowLevelPermissionDataSet(), other.rowLevelPermissionDataSet()) && this.hasRowLevelPermissionDataSetMap() == other.hasRowLevelPermissionDataSetMap() && Objects.equals(this.rowLevelPermissionDataSetMap(), other.rowLevelPermissionDataSetMap()) && Objects.equals(this.rowLevelPermissionTagConfigurationApplied(), other.rowLevelPermissionTagConfigurationApplied()) && Objects.equals(this.columnLevelPermissionRulesApplied(), other.columnLevelPermissionRulesApplied()) && Objects.equals(this.useAsAsString(), other.useAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetSummary").add("Arn", (Object)this.arn()).add("DataSetId", (Object)this.dataSetId()).add("Name", (Object)this.name()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ImportMode", (Object)this.importModeAsString()).add("RowLevelPermissionDataSet", (Object)this.rowLevelPermissionDataSet()).add("RowLevelPermissionDataSetMap", this.hasRowLevelPermissionDataSetMap() ? this.rowLevelPermissionDataSetMap() : null).add("RowLevelPermissionTagConfigurationApplied", (Object)this.rowLevelPermissionTagConfigurationApplied()).add("ColumnLevelPermissionRulesApplied", (Object)this.columnLevelPermissionRulesApplied()).add("UseAs", (Object)this.useAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "ImportMode": {
                return Optional.ofNullable(clazz.cast(this.importModeAsString()));
            }
            case "RowLevelPermissionDataSet": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionDataSet()));
            }
            case "RowLevelPermissionDataSetMap": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionDataSetMap()));
            }
            case "RowLevelPermissionTagConfigurationApplied": {
                return Optional.ofNullable(clazz.cast(this.rowLevelPermissionTagConfigurationApplied()));
            }
            case "ColumnLevelPermissionRulesApplied": {
                return Optional.ofNullable(clazz.cast(this.columnLevelPermissionRulesApplied()));
            }
            case "UseAs": {
                return Optional.ofNullable(clazz.cast(this.useAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("ImportMode", IMPORT_MODE_FIELD);
        map.put("RowLevelPermissionDataSet", ROW_LEVEL_PERMISSION_DATA_SET_FIELD);
        map.put("RowLevelPermissionDataSetMap", ROW_LEVEL_PERMISSION_DATA_SET_MAP_FIELD);
        map.put("RowLevelPermissionTagConfigurationApplied", ROW_LEVEL_PERMISSION_TAG_CONFIGURATION_APPLIED_FIELD);
        map.put("ColumnLevelPermissionRulesApplied", COLUMN_LEVEL_PERMISSION_RULES_APPLIED_FIELD);
        map.put("UseAs", USE_AS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetSummary, T> g) {
        return obj -> g.apply((DataSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String dataSetId;
        private String name;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String importMode;
        private RowLevelPermissionDataSet rowLevelPermissionDataSet;
        private Map<String, RowLevelPermissionDataSet> rowLevelPermissionDataSetMap = DefaultSdkAutoConstructMap.getInstance();
        private Boolean rowLevelPermissionTagConfigurationApplied;
        private Boolean columnLevelPermissionRulesApplied;
        private String useAs;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetSummary model) {
            this.arn(model.arn);
            this.dataSetId(model.dataSetId);
            this.name(model.name);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.importMode(model.importMode);
            this.rowLevelPermissionDataSet(model.rowLevelPermissionDataSet);
            this.rowLevelPermissionDataSetMap(model.rowLevelPermissionDataSetMap);
            this.rowLevelPermissionTagConfigurationApplied(model.rowLevelPermissionTagConfigurationApplied);
            this.columnLevelPermissionRulesApplied(model.columnLevelPermissionRulesApplied);
            this.useAs(model.useAs);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getImportMode() {
            return this.importMode;
        }

        public final void setImportMode(String importMode) {
            this.importMode = importMode;
        }

        @Override
        public final Builder importMode(String importMode) {
            this.importMode = importMode;
            return this;
        }

        @Override
        public final Builder importMode(DataSetImportMode importMode) {
            this.importMode(importMode == null ? null : importMode.toString());
            return this;
        }

        public final RowLevelPermissionDataSet.Builder getRowLevelPermissionDataSet() {
            return this.rowLevelPermissionDataSet != null ? this.rowLevelPermissionDataSet.toBuilder() : null;
        }

        public final void setRowLevelPermissionDataSet(RowLevelPermissionDataSet.BuilderImpl rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet != null ? rowLevelPermissionDataSet.build() : null;
        }

        @Override
        public final Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet rowLevelPermissionDataSet) {
            this.rowLevelPermissionDataSet = rowLevelPermissionDataSet;
            return this;
        }

        public final Map<String, RowLevelPermissionDataSet.Builder> getRowLevelPermissionDataSetMap() {
            Map<String, RowLevelPermissionDataSet.Builder> result = RowLevelPermissionDataSetMapCopier.copyToBuilder(this.rowLevelPermissionDataSetMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRowLevelPermissionDataSetMap(Map<String, RowLevelPermissionDataSet.BuilderImpl> rowLevelPermissionDataSetMap) {
            this.rowLevelPermissionDataSetMap = RowLevelPermissionDataSetMapCopier.copyFromBuilder(rowLevelPermissionDataSetMap);
        }

        @Override
        public final Builder rowLevelPermissionDataSetMap(Map<String, RowLevelPermissionDataSet> rowLevelPermissionDataSetMap) {
            this.rowLevelPermissionDataSetMap = RowLevelPermissionDataSetMapCopier.copy(rowLevelPermissionDataSetMap);
            return this;
        }

        public final Boolean getRowLevelPermissionTagConfigurationApplied() {
            return this.rowLevelPermissionTagConfigurationApplied;
        }

        public final void setRowLevelPermissionTagConfigurationApplied(Boolean rowLevelPermissionTagConfigurationApplied) {
            this.rowLevelPermissionTagConfigurationApplied = rowLevelPermissionTagConfigurationApplied;
        }

        @Override
        public final Builder rowLevelPermissionTagConfigurationApplied(Boolean rowLevelPermissionTagConfigurationApplied) {
            this.rowLevelPermissionTagConfigurationApplied = rowLevelPermissionTagConfigurationApplied;
            return this;
        }

        public final Boolean getColumnLevelPermissionRulesApplied() {
            return this.columnLevelPermissionRulesApplied;
        }

        public final void setColumnLevelPermissionRulesApplied(Boolean columnLevelPermissionRulesApplied) {
            this.columnLevelPermissionRulesApplied = columnLevelPermissionRulesApplied;
        }

        @Override
        public final Builder columnLevelPermissionRulesApplied(Boolean columnLevelPermissionRulesApplied) {
            this.columnLevelPermissionRulesApplied = columnLevelPermissionRulesApplied;
            return this;
        }

        public final String getUseAs() {
            return this.useAs;
        }

        public final void setUseAs(String useAs) {
            this.useAs = useAs;
        }

        @Override
        public final Builder useAs(String useAs) {
            this.useAs = useAs;
            return this;
        }

        @Override
        public final Builder useAs(DataSetUseAs useAs) {
            this.useAs(useAs == null ? null : useAs.toString());
            return this;
        }

        public DataSetSummary build() {
            return new DataSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetSummary> {
        public Builder arn(String var1);

        public Builder dataSetId(String var1);

        public Builder name(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder importMode(String var1);

        public Builder importMode(DataSetImportMode var1);

        public Builder rowLevelPermissionDataSet(RowLevelPermissionDataSet var1);

        default public Builder rowLevelPermissionDataSet(Consumer<RowLevelPermissionDataSet.Builder> rowLevelPermissionDataSet) {
            return this.rowLevelPermissionDataSet((RowLevelPermissionDataSet)((RowLevelPermissionDataSet.Builder)RowLevelPermissionDataSet.builder().applyMutation(rowLevelPermissionDataSet)).build());
        }

        public Builder rowLevelPermissionDataSetMap(Map<String, RowLevelPermissionDataSet> var1);

        public Builder rowLevelPermissionTagConfigurationApplied(Boolean var1);

        public Builder columnLevelPermissionRulesApplied(Boolean var1);

        public Builder useAs(String var1);

        public Builder useAs(DataSetUseAs var1);
    }
}

