/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Aggregation;
import software.amazon.awssdk.services.quicksight.model.AggregationListCopier;
import software.amazon.awssdk.services.quicksight.model.GroupByColumnNameListCopier;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(AggregateOperation.getter(AggregateOperation::alias)).setter(AggregateOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(AggregateOperation.getter(AggregateOperation::source)).setter(AggregateOperation.setter(Builder::source)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> GROUP_BY_COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupByColumnNames").getter(AggregateOperation.getter(AggregateOperation::groupByColumnNames)).setter(AggregateOperation.setter(Builder::groupByColumnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Aggregation>> AGGREGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregations").getter(AggregateOperation.getter(AggregateOperation::aggregations)).setter(AggregateOperation.setter(Builder::aggregations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Aggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD, GROUP_BY_COLUMN_NAMES_FIELD, AGGREGATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregateOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource source;
    private final List<String> groupByColumnNames;
    private final List<Aggregation> aggregations;

    private AggregateOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.groupByColumnNames = builder.groupByColumnNames;
        this.aggregations = builder.aggregations;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource source() {
        return this.source;
    }

    public final boolean hasGroupByColumnNames() {
        return this.groupByColumnNames != null && !(this.groupByColumnNames instanceof SdkAutoConstructList);
    }

    public final List<String> groupByColumnNames() {
        return this.groupByColumnNames;
    }

    public final boolean hasAggregations() {
        return this.aggregations != null && !(this.aggregations instanceof SdkAutoConstructList);
    }

    public final List<Aggregation> aggregations() {
        return this.aggregations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByColumnNames() ? this.groupByColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregations() ? this.aggregations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateOperation)) {
            return false;
        }
        AggregateOperation other = (AggregateOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.source(), other.source()) && this.hasGroupByColumnNames() == other.hasGroupByColumnNames() && Objects.equals(this.groupByColumnNames(), other.groupByColumnNames()) && this.hasAggregations() == other.hasAggregations() && Objects.equals(this.aggregations(), other.aggregations());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateOperation").add("Alias", (Object)this.alias()).add("Source", (Object)this.source()).add("GroupByColumnNames", this.hasGroupByColumnNames() ? this.groupByColumnNames() : null).add("Aggregations", this.hasAggregations() ? this.aggregations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "GroupByColumnNames": {
                return Optional.ofNullable(clazz.cast(this.groupByColumnNames()));
            }
            case "Aggregations": {
                return Optional.ofNullable(clazz.cast(this.aggregations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("GroupByColumnNames", GROUP_BY_COLUMN_NAMES_FIELD);
        map.put("Aggregations", AGGREGATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateOperation, T> g) {
        return obj -> g.apply((AggregateOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource source;
        private List<String> groupByColumnNames = DefaultSdkAutoConstructList.getInstance();
        private List<Aggregation> aggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateOperation model) {
            this.alias(model.alias);
            this.source(model.source);
            this.groupByColumnNames(model.groupByColumnNames);
            this.aggregations(model.aggregations);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getGroupByColumnNames() {
            if (this.groupByColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupByColumnNames;
        }

        public final void setGroupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = GroupByColumnNameListCopier.copy(groupByColumnNames);
        }

        @Override
        public final Builder groupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = GroupByColumnNameListCopier.copy(groupByColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByColumnNames(String ... groupByColumnNames) {
            this.groupByColumnNames(Arrays.asList(groupByColumnNames));
            return this;
        }

        public final List<Aggregation.Builder> getAggregations() {
            List<Aggregation.Builder> result = AggregationListCopier.copyToBuilder(this.aggregations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregations(Collection<Aggregation.BuilderImpl> aggregations) {
            this.aggregations = AggregationListCopier.copyFromBuilder(aggregations);
        }

        @Override
        public final Builder aggregations(Collection<Aggregation> aggregations) {
            this.aggregations = AggregationListCopier.copy(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(Aggregation ... aggregations) {
            this.aggregations(Arrays.asList(aggregations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(Consumer<Aggregation.Builder> ... aggregations) {
            this.aggregations(Stream.of(aggregations).map(c -> (Aggregation)((Aggregation.Builder)Aggregation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AggregateOperation build() {
            return new AggregateOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateOperation> {
        public Builder alias(String var1);

        public Builder source(TransformOperationSource var1);

        default public Builder source(Consumer<TransformOperationSource.Builder> source) {
            return this.source((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(source)).build());
        }

        public Builder groupByColumnNames(Collection<String> var1);

        public Builder groupByColumnNames(String ... var1);

        public Builder aggregations(Collection<Aggregation> var1);

        public Builder aggregations(Aggregation ... var1);

        public Builder aggregations(Consumer<Aggregation.Builder> ... var1);
    }
}

