/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ClientCredentialsSource;
import software.amazon.awssdk.services.quicksight.model.ReadClientCredentialsDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadClientCredentialsGrantMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadClientCredentialsGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseEndpoint").getter(ReadClientCredentialsGrantMetadata.getter(ReadClientCredentialsGrantMetadata::baseEndpoint)).setter(ReadClientCredentialsGrantMetadata.setter(Builder::baseEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()}).build();
    private static final SdkField<ReadClientCredentialsDetails> READ_CLIENT_CREDENTIALS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReadClientCredentialsDetails").getter(ReadClientCredentialsGrantMetadata.getter(ReadClientCredentialsGrantMetadata::readClientCredentialsDetails)).setter(ReadClientCredentialsGrantMetadata.setter(Builder::readClientCredentialsDetails)).constructor(ReadClientCredentialsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadClientCredentialsDetails").build()}).build();
    private static final SdkField<String> CLIENT_CREDENTIALS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCredentialsSource").getter(ReadClientCredentialsGrantMetadata.getter(ReadClientCredentialsGrantMetadata::clientCredentialsSourceAsString)).setter(ReadClientCredentialsGrantMetadata.setter(Builder::clientCredentialsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD, READ_CLIENT_CREDENTIALS_DETAILS_FIELD, CLIENT_CREDENTIALS_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReadClientCredentialsGrantMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseEndpoint;
    private final ReadClientCredentialsDetails readClientCredentialsDetails;
    private final String clientCredentialsSource;

    private ReadClientCredentialsGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.readClientCredentialsDetails = builder.readClientCredentialsDetails;
        this.clientCredentialsSource = builder.clientCredentialsSource;
    }

    public final String baseEndpoint() {
        return this.baseEndpoint;
    }

    public final ReadClientCredentialsDetails readClientCredentialsDetails() {
        return this.readClientCredentialsDetails;
    }

    public final ClientCredentialsSource clientCredentialsSource() {
        return ClientCredentialsSource.fromValue(this.clientCredentialsSource);
    }

    public final String clientCredentialsSourceAsString() {
        return this.clientCredentialsSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readClientCredentialsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadClientCredentialsGrantMetadata)) {
            return false;
        }
        ReadClientCredentialsGrantMetadata other = (ReadClientCredentialsGrantMetadata)obj;
        return Objects.equals(this.baseEndpoint(), other.baseEndpoint()) && Objects.equals(this.readClientCredentialsDetails(), other.readClientCredentialsDetails()) && Objects.equals(this.clientCredentialsSourceAsString(), other.clientCredentialsSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReadClientCredentialsGrantMetadata").add("BaseEndpoint", (Object)this.baseEndpoint()).add("ReadClientCredentialsDetails", (Object)this.readClientCredentialsDetails()).add("ClientCredentialsSource", (Object)this.clientCredentialsSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseEndpoint": {
                return Optional.ofNullable(clazz.cast(this.baseEndpoint()));
            }
            case "ReadClientCredentialsDetails": {
                return Optional.ofNullable(clazz.cast(this.readClientCredentialsDetails()));
            }
            case "ClientCredentialsSource": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("ReadClientCredentialsDetails", READ_CLIENT_CREDENTIALS_DETAILS_FIELD);
        map.put("ClientCredentialsSource", CLIENT_CREDENTIALS_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadClientCredentialsGrantMetadata, T> g) {
        return obj -> g.apply((ReadClientCredentialsGrantMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseEndpoint;
        private ReadClientCredentialsDetails readClientCredentialsDetails;
        private String clientCredentialsSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadClientCredentialsGrantMetadata model) {
            this.baseEndpoint(model.baseEndpoint);
            this.readClientCredentialsDetails(model.readClientCredentialsDetails);
            this.clientCredentialsSource(model.clientCredentialsSource);
        }

        public final String getBaseEndpoint() {
            return this.baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final ReadClientCredentialsDetails.Builder getReadClientCredentialsDetails() {
            return this.readClientCredentialsDetails != null ? this.readClientCredentialsDetails.toBuilder() : null;
        }

        public final void setReadClientCredentialsDetails(ReadClientCredentialsDetails.BuilderImpl readClientCredentialsDetails) {
            this.readClientCredentialsDetails = readClientCredentialsDetails != null ? readClientCredentialsDetails.build() : null;
        }

        @Override
        public final Builder readClientCredentialsDetails(ReadClientCredentialsDetails readClientCredentialsDetails) {
            this.readClientCredentialsDetails = readClientCredentialsDetails;
            return this;
        }

        public final String getClientCredentialsSource() {
            return this.clientCredentialsSource;
        }

        public final void setClientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
        }

        @Override
        public final Builder clientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
            return this;
        }

        @Override
        public final Builder clientCredentialsSource(ClientCredentialsSource clientCredentialsSource) {
            this.clientCredentialsSource(clientCredentialsSource == null ? null : clientCredentialsSource.toString());
            return this;
        }

        public ReadClientCredentialsGrantMetadata build() {
            return new ReadClientCredentialsGrantMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadClientCredentialsGrantMetadata> {
        public Builder baseEndpoint(String var1);

        public Builder readClientCredentialsDetails(ReadClientCredentialsDetails var1);

        default public Builder readClientCredentialsDetails(Consumer<ReadClientCredentialsDetails.Builder> readClientCredentialsDetails) {
            return this.readClientCredentialsDetails((ReadClientCredentialsDetails)((ReadClientCredentialsDetails.Builder)ReadClientCredentialsDetails.builder().applyMutation(readClientCredentialsDetails)).build());
        }

        public Builder clientCredentialsSource(String var1);

        public Builder clientCredentialsSource(ClientCredentialsSource var1);
    }
}

