/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation function that aggregates the total values of a measure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TotalAggregationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<TotalAggregationFunction.Builder, TotalAggregationFunction> {
    private static final SdkField<String> SIMPLE_TOTAL_AGGREGATION_FUNCTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SimpleTotalAggregationFunction")
            .getter(getter(TotalAggregationFunction::simpleTotalAggregationFunctionAsString))
            .setter(setter(Builder::simpleTotalAggregationFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleTotalAggregationFunction")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SIMPLE_TOTAL_AGGREGATION_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String simpleTotalAggregationFunction;

    private TotalAggregationFunction(BuilderImpl builder) {
        this.simpleTotalAggregationFunction = builder.simpleTotalAggregationFunction;
    }

    /**
     * <p>
     * A built in aggregation function for total values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simpleTotalAggregationFunction} will return {@link SimpleTotalAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #simpleTotalAggregationFunctionAsString}.
     * </p>
     * 
     * @return A built in aggregation function for total values.
     * @see SimpleTotalAggregationFunction
     */
    public final SimpleTotalAggregationFunction simpleTotalAggregationFunction() {
        return SimpleTotalAggregationFunction.fromValue(simpleTotalAggregationFunction);
    }

    /**
     * <p>
     * A built in aggregation function for total values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #simpleTotalAggregationFunction} will return {@link SimpleTotalAggregationFunction#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #simpleTotalAggregationFunctionAsString}.
     * </p>
     * 
     * @return A built in aggregation function for total values.
     * @see SimpleTotalAggregationFunction
     */
    public final String simpleTotalAggregationFunctionAsString() {
        return simpleTotalAggregationFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleTotalAggregationFunctionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TotalAggregationFunction)) {
            return false;
        }
        TotalAggregationFunction other = (TotalAggregationFunction) obj;
        return Objects.equals(simpleTotalAggregationFunctionAsString(), other.simpleTotalAggregationFunctionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TotalAggregationFunction")
                .add("SimpleTotalAggregationFunction", simpleTotalAggregationFunctionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SimpleTotalAggregationFunction":
            return Optional.ofNullable(clazz.cast(simpleTotalAggregationFunctionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SimpleTotalAggregationFunction", SIMPLE_TOTAL_AGGREGATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TotalAggregationFunction, T> g) {
        return obj -> g.apply((TotalAggregationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TotalAggregationFunction> {
        /**
         * <p>
         * A built in aggregation function for total values.
         * </p>
         * 
         * @param simpleTotalAggregationFunction
         *        A built in aggregation function for total values.
         * @see SimpleTotalAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleTotalAggregationFunction
         */
        Builder simpleTotalAggregationFunction(String simpleTotalAggregationFunction);

        /**
         * <p>
         * A built in aggregation function for total values.
         * </p>
         * 
         * @param simpleTotalAggregationFunction
         *        A built in aggregation function for total values.
         * @see SimpleTotalAggregationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleTotalAggregationFunction
         */
        Builder simpleTotalAggregationFunction(SimpleTotalAggregationFunction simpleTotalAggregationFunction);
    }

    static final class BuilderImpl implements Builder {
        private String simpleTotalAggregationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(TotalAggregationFunction model) {
            simpleTotalAggregationFunction(model.simpleTotalAggregationFunction);
        }

        public final String getSimpleTotalAggregationFunction() {
            return simpleTotalAggregationFunction;
        }

        public final void setSimpleTotalAggregationFunction(String simpleTotalAggregationFunction) {
            this.simpleTotalAggregationFunction = simpleTotalAggregationFunction;
        }

        @Override
        public final Builder simpleTotalAggregationFunction(String simpleTotalAggregationFunction) {
            this.simpleTotalAggregationFunction = simpleTotalAggregationFunction;
            return this;
        }

        @Override
        public final Builder simpleTotalAggregationFunction(SimpleTotalAggregationFunction simpleTotalAggregationFunction) {
            this.simpleTotalAggregationFunction(simpleTotalAggregationFunction == null ? null : simpleTotalAggregationFunction
                    .toString());
            return this;
        }

        @Override
        public TotalAggregationFunction build() {
            return new TotalAggregationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
